/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block.InfestationEntries;

import com.github.sculkhorde.common.block.InfestationEntries.IBlockInfestationEntry;
import com.github.sculkhorde.common.block.InfestationEntries.ITagInfestedBlock;
import com.github.sculkhorde.common.block.InfestationEntries.ITagInfestedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockTagInfestationTableEntry
implements IBlockInfestationEntry {
    protected TagKey<Block> normalVariantTag;
    protected ITagInfestedBlock infectedVariant;

    private static <T extends Comparable<T>> BlockState copyBlockProperty(BlockState from, BlockState to, Property<T> property) {
        try {
            return (BlockState)to.m_61124_(property, from.m_61143_(property));
        }
        catch (IllegalArgumentException e) {
            return to;
        }
    }

    public BlockTagInfestationTableEntry(TagKey<Block> normalVariantIn, ITagInfestedBlock infectedVariantIn) {
        this.normalVariantTag = normalVariantIn;
        this.infectedVariant = infectedVariantIn;
    }

    @Override
    public boolean isNormalVariant(BlockState blockState) {
        return blockState.m_204336_(this.normalVariantTag);
    }

    @Override
    public boolean isInfectedVariant(BlockState blockState) {
        return ((Block)this.infectedVariant).m_49966_().m_60713_(blockState.m_60734_());
    }

    @Override
    public BlockState getNormalVariant(Level level, BlockPos blockPos) {
        ITagInfestedBlockEntity blockEntity = this.infectedVariant.getTagInfestedBlockEntity(level, blockPos);
        if (blockEntity == null || blockEntity.getNormalBlockState() == null) {
            return level.m_8055_(blockPos);
        }
        return this.infectedVariant.getTagInfestedBlockEntity(level, blockPos).getNormalBlockState();
    }

    @Override
    public BlockState getInfectedVariant(Level level, BlockPos blockPos) {
        BlockState infectedState = ((Block)this.infectedVariant).m_49966_();
        for (Property prop : level.m_8055_(blockPos).m_61147_()) {
            infectedState = BlockTagInfestationTableEntry.copyBlockProperty(level.m_8055_(blockPos), infectedState, prop);
        }
        return infectedState;
    }
}

