/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block.InfestationEntries;

import com.github.sculkhorde.common.block.InfestationEntries.IBlockInfestationEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockInfestationTableEntry
implements IBlockInfestationEntry {
    protected Block normalVariant;
    protected BlockState infectedVariant;

    private static <T extends Comparable<T>> BlockState copyBlockProperty(BlockState from, BlockState to, Property<T> property) {
        try {
            return (BlockState)to.m_61124_(property, from.m_61143_(property));
        }
        catch (IllegalArgumentException e) {
            return to;
        }
    }

    public BlockInfestationTableEntry(Block normalVariantIn, BlockState infectedVariantIn) {
        this.normalVariant = normalVariantIn;
        this.infectedVariant = infectedVariantIn;
    }

    @Override
    public boolean isNormalVariant(BlockState blockState) {
        return blockState.m_60713_(this.normalVariant);
    }

    @Override
    public boolean isInfectedVariant(BlockState blockState) {
        return this.infectedVariant.m_60713_(blockState.m_60734_());
    }

    @Override
    public BlockState getNormalVariant(Level level, BlockPos blockPos) {
        return this.getNormalVariant(level.m_8055_(blockPos));
    }

    @Override
    public BlockState getInfectedVariant(Level level, BlockPos blockPos) {
        return this.getInfectedVariant(level.m_8055_(blockPos));
    }

    public BlockState getNormalVariant(BlockState blockState) {
        BlockState normalState = this.normalVariant.m_49966_();
        for (Property prop : blockState.m_61147_()) {
            normalState = BlockInfestationTableEntry.copyBlockProperty(blockState, normalState, prop);
        }
        return normalState;
    }

    public BlockState getInfectedVariant(BlockState blockState) {
        for (Property prop : blockState.m_61147_()) {
            this.infectedVariant = BlockInfestationTableEntry.copyBlockProperty(blockState, this.infectedVariant, prop);
        }
        return this.infectedVariant;
    }
}

