/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block.InfestationEntries;

import com.github.sculkhorde.common.block.InfestationEntries.BlockIDOnlyCurableTableEntry;
import com.github.sculkhorde.common.block.InfestationEntries.BlockInfestationTableEntry;
import com.github.sculkhorde.common.block.InfestationEntries.BlockTagInfestationTableEntry;
import com.github.sculkhorde.common.block.InfestationEntries.IBlockInfestationEntry;
import com.github.sculkhorde.common.block.InfestationEntries.ITagInfestedBlock;
import com.github.sculkhorde.common.block.InfestationEntries.ToolTaglInfestationTableEntry;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockInfestationTable {
    private List<IBlockInfestationEntry> entries = new ArrayList<IBlockInfestationEntry>();
    protected boolean denyNonSolidBlocks = true;

    public BlockInfestationTable(boolean denyNonSolidBlocks) {
        this.setDenyNonSolidBlocks(denyNonSolidBlocks);
    }

    public boolean isDenyNonSolidBlocks() {
        return this.denyNonSolidBlocks;
    }

    public void setDenyNonSolidBlocks(boolean denyNonSolidBlocks) {
        this.denyNonSolidBlocks = denyNonSolidBlocks;
    }

    public void addEntry(Block normalVariant, BlockState infectedVariant) {
        this.entries.add(new BlockInfestationTableEntry(normalVariant, infectedVariant));
    }

    public void addEntry(TagKey<Block> normalTag, ITagInfestedBlock infectedVariant) {
        this.entries.add(new BlockTagInfestationTableEntry(normalTag, infectedVariant));
    }

    public void addEntry(String normalBlockID, String infectedBlockID) {
        this.entries.add(new BlockIDOnlyCurableTableEntry(normalBlockID, infectedBlockID));
    }

    public void addEntry(TagKey<Block> toolRequired, Tier tier, ITagInfestedBlock infectedVariant) {
        this.entries.add(new ToolTaglInfestationTableEntry(toolRequired, tier, infectedVariant));
    }

    public BlockState getInfestedVariant(Level level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos);
        for (IBlockInfestationEntry entry : this.entries) {
            if (!entry.isNormalVariant(blockState)) continue;
            return entry.getInfectedVariant(level, blockPos);
        }
        return null;
    }

    public BlockState getNormalVariant(Level level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos);
        for (IBlockInfestationEntry entry : this.entries) {
            if (!entry.isInfectedVariant(blockState)) continue;
            return entry.getNormalVariant(level, blockPos);
        }
        return null;
    }

    public boolean canBeInfectedByThisTable(ServerLevel level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        boolean areWeDenyingNonSolidBlocks = this.isDenyNonSolidBlocks();
        boolean isBlockNotSolid = BlockAlgorithms.isNotSolid(level, pos);
        if (areWeDenyingNonSolidBlocks && isBlockNotSolid) {
            return false;
        }
        for (IBlockInfestationEntry entry : this.entries) {
            if (!entry.isNormalVariant(blockState)) continue;
            return true;
        }
        return false;
    }

    public boolean infectBlock(ServerLevel world, BlockPos targetPos) {
        if (world == null || !this.canBeInfectedByThisTable(world, targetPos)) {
            return false;
        }
        BlockState oldBlock = world.m_8055_(targetPos);
        BlockState newBlock = this.getInfestedVariant((Level)world, targetPos);
        if (newBlock == null) {
            return false;
        }
        world.m_46597_(targetPos, newBlock);
        world.m_5594_(null, targetPos, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 0.6f + world.m_213780_().m_188501_() * 0.4f);
        if (newBlock.m_60734_() instanceof ITagInfestedBlock) {
            ((ITagInfestedBlock)newBlock.m_60734_()).getTagInfestedBlockEntity((Level)world, targetPos).setNormalBlockState(oldBlock);
        }
        return true;
    }
}

