/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block.InfestationEntries;

import com.github.sculkhorde.common.block.InfestationEntries.IBlockInfestationEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockIDOnlyCurableTableEntry
implements IBlockInfestationEntry {
    protected String normalVariantID;
    protected String infectedVariantID;

    private static <T extends Comparable<T>> BlockState copyBlockProperty(BlockState from, BlockState to, Property<T> property) {
        try {
            return (BlockState)to.m_61124_(property, from.m_61143_(property));
        }
        catch (IllegalArgumentException e) {
            return to;
        }
    }

    public BlockIDOnlyCurableTableEntry(String normalVariantIn, String infectedVariantIn) {
        this.normalVariantID = normalVariantIn;
        this.infectedVariantID = infectedVariantIn;
    }

    @Override
    public boolean isNormalVariant(BlockState blockState) {
        return false;
    }

    @Override
    public boolean isInfectedVariant(BlockState blockState) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()).toString().equals(this.infectedVariantID);
    }

    @Override
    public BlockState getNormalVariant(Level level, BlockPos blockPos) {
        return this.getNormalVariant(level.m_8055_(blockPos));
    }

    @Override
    public BlockState getInfectedVariant(Level level, BlockPos blockPos) {
        return this.getInfectedVariant(level.m_8055_(blockPos));
    }

    public BlockState getNormalVariant(BlockState infectedBlockState) {
        Block normalVariantBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(this.normalVariantID));
        BlockState normalVariantBlockState = normalVariantBlock.m_49966_();
        for (Property prop : infectedBlockState.m_61147_()) {
            normalVariantBlockState = BlockIDOnlyCurableTableEntry.copyBlockProperty(infectedBlockState, normalVariantBlockState, prop);
        }
        return normalVariantBlockState;
    }

    public BlockState getInfectedVariant(BlockState blockState) {
        Block infectedVariantBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(this.infectedVariantID));
        BlockState infectedVariantBlockState = infectedVariantBlock.m_49966_();
        for (Property prop : blockState.m_61147_()) {
            infectedVariantBlockState = BlockIDOnlyCurableTableEntry.copyBlockProperty(blockState, infectedVariantBlockState, prop);
        }
        return infectedVariantBlockState;
    }
}

