/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers.mixins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.smarterfarmers.CountOrderedSortedMap;
import net.mehvahdjukaar.smarterfarmers.FarmTaskLogic;
import net.mehvahdjukaar.smarterfarmers.SFPlatformStuff;
import net.mehvahdjukaar.smarterfarmers.SmarterFarmers;
import net.mehvahdjukaar.smarterfarmers.integration.QuarkIntegration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HarvestFarmland.class}, priority=1200)
public abstract class HarvestFarmlandMixin {
    @Shadow
    private BlockPos f_23159_;
    @Shadow
    private long f_23160_;
    @Final
    @Shadow
    private List<BlockPos> f_23162_;
    @Shadow
    private int f_23161_;

    @Shadow
    protected abstract BlockPos m_23164_(ServerLevel var1);

    @Inject(method={"start(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;J)V"}, at={@At(value="HEAD")})
    public void start(ServerLevel level, Villager villager, long pGameTime, CallbackInfo ci) {
        if (pGameTime > this.f_23160_ && this.f_23159_ != null) {
            villager.m_8061_(EquipmentSlot.MAINHAND, FarmTaskLogic.getHoe(villager));
        }
    }

    @Inject(method={"stop(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;J)V"}, at={@At(value="HEAD")})
    public void stop(ServerLevel level, Villager villager, long pGameTime, CallbackInfo ci) {
        villager.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
    }

    @Overwrite
    protected boolean m_23180_(BlockPos pPos, ServerLevel level) {
        BlockState cropState = level.m_8055_(pPos);
        BlockState farmState = level.m_8055_(pPos.m_7495_());
        if (cropState.m_60795_() || FarmTaskLogic.isCropMature(cropState)) {
            return FarmTaskLogic.isValidFarmland(farmState);
        }
        if (FarmTaskLogic.canSpecialBreak(cropState)) {
            return FarmTaskLogic.isValidFarmland(farmState) || farmState.m_204336_(BlockTags.f_144274_);
        }
        return false;
    }

    @Inject(method={"tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;J)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(ServerLevel level, Villager villager, long tickCount, CallbackInfo ci) {
        if (this.f_23159_ == null || this.f_23159_.m_203195_((Position)villager.m_20182_(), 1.0)) {
            if (this.f_23159_ != null && tickCount > this.f_23160_) {
                BlockState toHarvest = level.m_8055_(this.f_23159_);
                BlockPos belowPos = this.f_23159_.m_7495_();
                Item toReplace = Items.f_41852_;
                if (!toHarvest.m_60795_()) {
                    if (FarmTaskLogic.canSpecialBreak(toHarvest)) {
                        level.m_46953_(this.f_23159_, true, (Entity)villager);
                        BlockState below = level.m_8055_(belowPos);
                        if (SFPlatformStuff.tillBlock(below, belowPos, level)) {
                            level.m_5594_(null, belowPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        if (FarmTaskLogic.canBreakNoReplant(toHarvest)) {
                            ++this.f_23161_;
                            ci.cancel();
                            return;
                        }
                    } else if (FarmTaskLogic.isCropMature(toHarvest)) {
                        if (SmarterFarmers.QUARK && QuarkIntegration.breakWithAutoReplant(level, this.f_23159_, (Entity)villager)) {
                            ++this.f_23161_;
                            ci.cancel();
                            return;
                        }
                        toReplace = toHarvest.m_60734_().m_5456_();
                        level.m_46953_(this.f_23159_, true, (Entity)villager);
                    }
                }
                BlockState farmlandBlock = level.m_8055_(belowPos);
                if (level.m_8055_(this.f_23159_).m_60795_() && FarmTaskLogic.isValidFarmland(farmlandBlock)) {
                    SimpleContainer inventory = villager.m_35311_();
                    ItemStack itemStack = ItemStack.f_41583_;
                    boolean canPlant = false;
                    int ind = -1;
                    if (toReplace != Items.f_41852_ && toReplace instanceof BlockItem) {
                        for (int i = 0; i < inventory.m_6643_(); ++i) {
                            itemStack = inventory.m_8020_(i);
                            if (itemStack.m_41720_() != toReplace) continue;
                            canPlant = true;
                            ind = i;
                            break;
                        }
                    }
                    if (!canPlant) {
                        Optional opt;
                        CountOrderedSortedMap<Block> map = new CountOrderedSortedMap<Block>();
                        map.add(level.m_8055_(this.f_23159_.m_122012_()).m_60734_());
                        map.add(level.m_8055_(this.f_23159_.m_122019_()).m_60734_());
                        map.add(level.m_8055_(this.f_23159_.m_122029_()).m_60734_());
                        map.add(level.m_8055_(this.f_23159_.m_122024_()).m_60734_());
                        ArrayList surroundingBlocks = new ArrayList();
                        map.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(e -> surroundingBlocks.add((Block)e.getKey()));
                        HashMap<Block, Integer> availableSeeds = new HashMap<Block, Integer>();
                        for (int i = 0; i < inventory.m_6643_(); ++i) {
                            itemStack = inventory.m_8020_(i);
                            Item it = itemStack.m_41720_();
                            Block cc = SFPlatformStuff.getCropFromSeed(level, this.f_23159_, it);
                            if (cc == null) continue;
                            availableSeeds.put(cc, i);
                        }
                        for (Block b : surroundingBlocks) {
                            if (!availableSeeds.containsKey(b)) continue;
                            ind = (Integer)availableSeeds.get(b);
                            canPlant = true;
                            itemStack = inventory.m_8020_(ind);
                            break;
                        }
                        if (!canPlant && (opt = availableSeeds.values().stream().findFirst()).isPresent()) {
                            ind = (Integer)opt.get();
                            canPlant = true;
                            itemStack = inventory.m_8020_(ind);
                        }
                    }
                    if (canPlant) {
                        level.m_7731_(this.f_23159_, SFPlatformStuff.getPlant(level, this.f_23159_, itemStack), 3);
                        level.m_6263_(null, (double)this.f_23159_.m_123341_(), (double)this.f_23159_.m_123342_(), (double)this.f_23159_.m_123343_(), SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        itemStack.m_41774_(1);
                        if (itemStack.m_41619_()) {
                            inventory.m_6836_(ind, ItemStack.f_41583_);
                        }
                    }
                }
                if (!FarmTaskLogic.isCropMature(toHarvest)) {
                    this.f_23162_.remove(this.f_23159_);
                    this.f_23159_ = this.m_23164_(level);
                    if (this.f_23159_ != null) {
                        this.f_23160_ = tickCount + 20L;
                        villager.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.f_23159_), 0.5f, 1));
                        villager.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.f_23159_));
                    }
                }
            }
            ++this.f_23161_;
        }
        ci.cancel();
    }
}

