/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sculkhornid.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ModConfigs {
    public static ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec.DoubleValue DISTANCE_DAMAGE;
    public static ForgeConfigSpec.IntValue DISTANCE_DISTANCE;
    public static ForgeConfigSpec.IntValue DISTANCE_COOLDOWN;
    public static ForgeConfigSpec.IntValue DISTANCE_EXPERIENCE_LEVEL;
    public static ForgeConfigSpec.IntValue DISTANCE_REMOVE_EXPERIENCE;
    public static ForgeConfigSpec.IntValue DISTANCE_DURABILITY;
    public static ForgeConfigSpec.IntValue DISTANCE_USE_TIME;
    public static ForgeConfigSpec.DoubleValue AREA_DAMAGE;
    public static ForgeConfigSpec.DoubleValue AREA_RADIUS;
    public static ForgeConfigSpec.IntValue AREA_COOLDOWN;
    public static ForgeConfigSpec.IntValue AREA_EXPERIENCE_LEVEL;
    public static ForgeConfigSpec.IntValue AREA_REMOVE_EXPERIENCE;
    public static ForgeConfigSpec.IntValue AREA_DURABILITY;
    public static ForgeConfigSpec.IntValue AREA_SPEED_DURATION;
    public static ForgeConfigSpec.IntValue AREA_SPEED_AMPLIFIER;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        config.load();
        spec.setConfig((CommentedConfig)config);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("SculkHornMod");
        DISTANCE_DAMAGE = builder.defineInRange("distance_DAMAGE", 8.0, 1.0, 10000.0);
        DISTANCE_DISTANCE = builder.defineInRange("distance_DISTANCE", 16, 0, 10000);
        DISTANCE_COOLDOWN = builder.defineInRange("distance_COOLDOWN", 200, 0, 10000);
        DISTANCE_EXPERIENCE_LEVEL = builder.defineInRange("distance_EXPERIENCE_LEVEL", 5, 0, 10000);
        DISTANCE_REMOVE_EXPERIENCE = builder.defineInRange("distance_REMOVE_EXPERIENCE", -55, -10000, 10000);
        DISTANCE_DURABILITY = builder.defineInRange("distance_DURABILITY", 500, 0, 10000);
        DISTANCE_USE_TIME = builder.defineInRange("distance_USE_TIME", 10, 1, 10000);
        AREA_DAMAGE = builder.defineInRange("area_Damage", 12.0, 1.0, 10000.0);
        AREA_RADIUS = builder.defineInRange("area_RADIUS", 3.5, 1.0, 10000.0);
        AREA_COOLDOWN = builder.defineInRange("area_cooldown", 300, 0, 10000);
        AREA_EXPERIENCE_LEVEL = builder.defineInRange("area_EXPERIENCE_LEVEL", 5, 0, 10000);
        AREA_REMOVE_EXPERIENCE = builder.defineInRange("area_REMOVE_EXPERIENCE", -55, -10000, 10000);
        AREA_DURABILITY = builder.defineInRange("area_DURABILITY", 350, 0, 10000);
        AREA_SPEED_DURATION = builder.defineInRange("area_SPEED_DURATION", 30, 0, 10000);
        AREA_SPEED_AMPLIFIER = builder.defineInRange("area_SPEED_AMPLIFIER", 0, 0, 10000);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

