/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sculkhornid.api;

import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class Helper {
    public static float ticksToSeconds(int cooldown) {
        return (float)cooldown / 20.0f;
    }

    public static void causeMagicExplosionAttack(Level level, LivingEntity user, LivingEntity victim, float damageAmount, float distance) {
        DamageSource magicExplosion = level.m_269111_().m_269036_((Entity)user, (Entity)user);
        for (LivingEntity nearbyEntity : Helper.getAoeTargets(victim, user, distance)) {
            nearbyEntity.m_6469_(magicExplosion, damageAmount);
        }
    }

    private static List<LivingEntity> getAoeTargets(LivingEntity center, LivingEntity attacker, float distance) {
        return center.m_20193_().m_6443_(LivingEntity.class, new AABB(center.m_20183_()).m_82400_((double)distance), nearbyEntity -> Helper.isAoeTarget(nearbyEntity, attacker, center));
    }

    private static boolean isAoeTarget(LivingEntity self, LivingEntity attacker, LivingEntity center) {
        return self != attacker && self.m_6084_() && !Helper.isAllOf(attacker, self) && !Helper.isUnaffected(self) && center.m_142582_((Entity)self);
    }

    private static boolean isAllOf(LivingEntity self, LivingEntity other) {
        return self.m_7307_((Entity)other) || Helper.excludeFromDamge(other);
    }

    private static boolean excludeFromDamge(LivingEntity nearbyEntity) {
        return nearbyEntity instanceof Wolf || nearbyEntity instanceof Villager || nearbyEntity instanceof Allay;
    }

    private static boolean isUnaffected(LivingEntity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).m_7500_();
        }
        return false;
    }
}

