/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.server;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import team.creative.cmdcam.CMDCam;
import team.creative.cmdcam.client.SceneException;
import team.creative.cmdcam.common.command.CamCommandProcessor;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.packet.StartPathPacket;
import team.creative.cmdcam.common.packet.TeleportPathPacket;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.cmdcam.server.CMDCamServer;
import team.creative.creativecore.common.network.CreativePacket;

public class CamCommandProcessorServer
implements CamCommandProcessor {
    @Override
    public CamScene getScene(CommandContext<CommandSourceStack> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        CamScene scene = CMDCamServer.get((Level)((CommandSourceStack)context.getSource()).m_81372_(), name);
        return scene;
    }

    @Override
    public boolean canSelectTarget() {
        return false;
    }

    @Override
    public void selectTarget(CommandContext<CommandSourceStack> context, boolean look) {
    }

    @Override
    public boolean canCreatePoint(CommandContext<CommandSourceStack> context) {
        return ((CommandSourceStack)context.getSource()).m_81373_() != null;
    }

    @Override
    public CamPoint createPoint(CommandContext<CommandSourceStack> context) {
        return CamPoint.create(((CommandSourceStack)context.getSource()).m_81373_());
    }

    @Override
    public boolean requiresSceneName() {
        return true;
    }

    @Override
    public boolean requiresPlayer() {
        return true;
    }

    public Collection<ServerPlayer> getPlayers(CommandContext<CommandSourceStack> context) {
        try {
            return EntityArgument.m_91477_(context, (String)"players");
        }
        catch (CommandSyntaxException e) {
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public void start(CommandContext<CommandSourceStack> context) throws SceneException {
        CamScene scene = this.getScene(context);
        if (scene.points.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"scene.create_fail"));
            return;
        }
        StartPathPacket packet = new StartPathPacket(scene);
        for (ServerPlayer player : this.getPlayers(context)) {
            CMDCam.NETWORK.sendToClient((CreativePacket)packet, player);
        }
    }

    @Override
    public void teleport(CommandContext<CommandSourceStack> context, int index) {
        TeleportPathPacket packet = new TeleportPathPacket(this.getScene(context).points.get(index));
        for (ServerPlayer player : this.getPlayers(context)) {
            CMDCam.NETWORK.sendToClient((CreativePacket)packet, player);
        }
    }

    @Override
    public void markDirty(CommandContext<CommandSourceStack> context) {
        CMDCamServer.markDirty((Level)((CommandSourceStack)context.getSource()).m_81372_());
    }

    @Override
    public Player getPlayer(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return EntityArgument.m_91474_(context, (String)"player");
    }

    @Override
    public Entity getEntity(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return EntityArgument.m_91452_(context, (String)name);
    }
}

