/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.target;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;
import team.creative.creativecore.common.util.registry.exception.RegistryException;

public abstract class CamTarget {
    public static final NamedTypeRegistry<CamTarget> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[0]);

    public static CamTarget load(CompoundTag nbt) {
        try {
            CamTarget target = (CamTarget)REGISTRY.create(nbt.m_128461_("id"), new Object[0]);
            target.loadExtra(nbt);
            return target;
        }
        catch (RegistryException e) {
            return null;
        }
    }

    public abstract Vec3d position(Level var1, float var2);

    protected abstract void saveExtra(CompoundTag var1);

    protected abstract void loadExtra(CompoundTag var1);

    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128359_("id", REGISTRY.getId((Object)this));
        this.saveExtra(nbt);
        return nbt;
    }

    public void start(Level level) {
    }

    public void finish() {
    }

    static {
        REGISTRY.register("pos", BlockTarget.class);
        REGISTRY.register("entity", EntityTarget.class);
        REGISTRY.register("self", SelfTarget.class);
        REGISTRY.register("player", PlayerTarget.class);
    }

    public static class BlockTarget
    extends CamTarget {
        public BlockPos pos;

        public BlockTarget() {
        }

        public BlockTarget(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public Vec3d position(Level level, float partialTicks) {
            return new Vec3d((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5);
        }

        @Override
        protected void saveExtra(CompoundTag nbt) {
            nbt.m_128385_("data", new int[]{this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()});
        }

        @Override
        protected void loadExtra(CompoundTag nbt) {
            int[] array = nbt.m_128465_("data");
            if (array == null || array.length != 3) {
                throw new IllegalArgumentException("Invalid block target data=" + array);
            }
            this.pos = new BlockPos(array[0], array[1], array[2]);
        }
    }

    public static class EntityTarget
    extends CamTarget {
        public Entity cachedEntity;
        public UUID uuid;

        public EntityTarget() {
        }

        public EntityTarget(Entity entity) {
            this.uuid = entity.m_20148_();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void start(Level level) {
            if (level instanceof ServerLevel) {
                this.cachedEntity = (Entity)((ServerLevel)level).m_142646_().m_142694_(this.uuid);
            } else {
                for (Entity entity : ((ClientLevel)level).m_104735_()) {
                    if (!entity.m_20148_().equals(this.uuid)) continue;
                    this.cachedEntity = entity;
                    break;
                }
            }
        }

        @Override
        public void finish() {
            this.cachedEntity = null;
        }

        @Override
        public Vec3d position(Level level, float partialTicks) {
            if (this.cachedEntity != null && !this.cachedEntity.m_6084_()) {
                this.cachedEntity = null;
            }
            if (this.cachedEntity != null) {
                return new Vec3d(this.cachedEntity.m_20299_(partialTicks));
            }
            return null;
        }

        @Override
        protected void saveExtra(CompoundTag nbt) {
            nbt.m_128359_("uuid", this.uuid.toString());
        }

        @Override
        protected void loadExtra(CompoundTag nbt) {
            this.uuid = UUID.fromString(nbt.m_128461_("uuid"));
        }
    }

    public static class SelfTarget
    extends CamTarget {
        @Override
        protected void saveExtra(CompoundTag nbt) {
        }

        @Override
        protected void loadExtra(CompoundTag nbt) {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Vec3d position(Level level, float partialTicks) {
            return new Vec3d(Minecraft.m_91087_().f_91074_.m_20299_(partialTicks));
        }
    }

    public static class PlayerTarget
    extends CamTarget {
        public Player cachedPlayer;
        public UUID uuid;

        public PlayerTarget() {
        }

        public PlayerTarget(Player player) {
            this.cachedPlayer = player;
            this.uuid = player.m_20148_();
        }

        @Override
        public void start(Level level) {
            this.cachedPlayer = level.m_46003_(this.uuid);
        }

        @Override
        public void finish() {
            this.cachedPlayer = null;
        }

        @Override
        public Vec3d position(Level level, float partialTicks) {
            if (this.cachedPlayer == null || !this.cachedPlayer.m_6084_()) {
                return null;
            }
            return new Vec3d(this.cachedPlayer.m_20299_(partialTicks));
        }

        @Override
        protected void saveExtra(CompoundTag nbt) {
            nbt.m_128359_("uuid", this.uuid.toString());
        }

        @Override
        protected void loadExtra(CompoundTag nbt) {
            this.uuid = UUID.fromString(nbt.m_128461_("uuid"));
        }
    }
}

