/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.command.builder;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.util.TriConsumer;
import team.creative.cmdcam.common.command.CamCommandProcessor;
import team.creative.cmdcam.common.command.argument.CamModeArgument;
import team.creative.cmdcam.common.command.argument.CamPitchModeArgument;
import team.creative.cmdcam.common.command.argument.DurationArgument;
import team.creative.cmdcam.common.command.argument.InterpolationArgument;
import team.creative.cmdcam.common.command.builder.FollowArgumentBuilder;
import team.creative.cmdcam.common.command.builder.PointArgumentBuilder;
import team.creative.cmdcam.common.command.builder.TargetArgumentBuilder;
import team.creative.cmdcam.common.math.interpolation.CamInterpolation;
import team.creative.cmdcam.common.math.interpolation.CamPitchMode;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.cmdcam.common.scene.attribute.CamAttribute;

public class SceneCommandBuilder {
    public static void scene(ArgumentBuilder<CommandSourceStack, ?> origin, CamCommandProcessor processor) {
        LiteralArgumentBuilder tpO;
        RequiredArgumentBuilder original = origin;
        if (processor.requiresSceneName()) {
            origin = Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string());
        }
        origin.then(Commands.m_82127_((String)"clear").executes(x -> {
            processor.getScene((CommandContext<CommandSourceStack>)x).points.clear();
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237115_((String)"scene.clear"), false);
            return 0;
        }));
        origin.then((ArgumentBuilder)new PointArgumentBuilder("add", (x, point) -> {
            processor.getScene((CommandContext<CommandSourceStack>)x).points.add((CamPoint)((Object)point));
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.add", (Object[])new Object[]{processor.getScene((CommandContext<CommandSourceStack>)x).points.size()}), false);
        }, processor));
        origin.then((ArgumentBuilder)new PointArgumentBuilder("insert", (TriConsumer<CommandContext<CommandSourceStack>, CamPoint, Integer>)((TriConsumer)(x, point, index) -> {
            processor.getScene((CommandContext<CommandSourceStack>)x).points.add((int)index, (CamPoint)((Object)point));
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.insert", (Object[])new Object[]{index + 1}), false);
        }), processor));
        origin.then((ArgumentBuilder)new PointArgumentBuilder("set", (TriConsumer<CommandContext<CommandSourceStack>, CamPoint, Integer>)((TriConsumer)(x, point, index) -> {
            processor.getScene((CommandContext<CommandSourceStack>)x).points.set((int)index, (CamPoint)((Object)point));
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.set", (Object[])new Object[]{index + 1}), false);
        }), processor));
        origin.then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            int index = IntegerArgumentType.getInteger((CommandContext)x, (String)"index") - 1;
            CamScene scene = processor.getScene((CommandContext<CommandSourceStack>)x);
            if (index >= 0 && index < scene.points.size()) {
                scene.points.remove(index);
            } else {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237110_((String)"scene.index", (Object[])new Object[]{index + 1}));
            }
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            return 0;
        })));
        origin.then(Commands.m_82127_((String)"duration").then(Commands.m_82129_((String)"duration", (ArgumentType)DurationArgument.duration()).executes(x -> {
            long duration = DurationArgument.getDuration(x, "duration");
            if (duration > 0L) {
                processor.getScene((CommandContext<CommandSourceStack>)x).duration = duration;
            }
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.duration", (Object[])new Object[]{duration}), false);
            return 0;
        })));
        origin.then(Commands.m_82127_((String)"loops").then(Commands.m_82129_((String)"loop", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(x -> {
            int loop;
            processor.getScene((CommandContext<CommandSourceStack>)x).loop = loop = IntegerArgumentType.getInteger((CommandContext)x, (String)"loop");
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            if (loop == 0) {
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.add", (Object[])new Object[]{processor.getScene((CommandContext<CommandSourceStack>)x).points.size()}), false);
            } else if (loop < 0) {
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237115_((String)"scene.loops.endless"), false);
            } else {
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.loops", (Object[])new Object[]{loop}), false);
            }
            return 0;
        })));
        LiteralArgumentBuilder tp = tpO = Commands.m_82127_((String)"goto");
        if (processor.requiresPlayer()) {
            tp = Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_());
        }
        tp.then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(x -> {
            int index = IntegerArgumentType.getInteger((CommandContext)x, (String)"index") - 1;
            CamScene scene = processor.getScene((CommandContext<CommandSourceStack>)x);
            if (index >= 0 && index < scene.points.size()) {
                processor.teleport((CommandContext<CommandSourceStack>)x, index);
            } else {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237110_((String)"scene.index", (Object[])new Object[]{index + 1}));
            }
            return 0;
        }));
        if (processor.requiresPlayer()) {
            origin.then(tpO.then((ArgumentBuilder)tp));
        } else {
            origin.then((ArgumentBuilder)tpO);
        }
        origin.then(Commands.m_82127_((String)"mode").then(Commands.m_82129_((String)"mode", (ArgumentType)CamModeArgument.mode()).executes(x -> {
            processor.getScene((CommandContext<CommandSourceStack>)x).setMode(StringArgumentType.getString((CommandContext)x, (String)"mode"));
            return 0;
        })));
        origin.then((ArgumentBuilder)new TargetArgumentBuilder("target", true, processor));
        origin.then((ArgumentBuilder)new TargetArgumentBuilder("follow", false, processor));
        origin.then((ArgumentBuilder)new FollowArgumentBuilder(CamAttribute.PITCH, processor)).then((ArgumentBuilder)new FollowArgumentBuilder(CamAttribute.YAW, processor)).then((ArgumentBuilder)new FollowArgumentBuilder(CamAttribute.POSITION, processor));
        origin.then(Commands.m_82127_((String)"interpolation").then(Commands.m_82129_((String)"interpolation", (ArgumentType)InterpolationArgument.interpolation()).executes(x -> {
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            processor.getScene((CommandContext<CommandSourceStack>)x).interpolation = (CamInterpolation)CamInterpolation.REGISTRY.get(interpolation);
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.interpolation", (Object[])new Object[]{interpolation}), false);
            return 0;
        })));
        origin.then(Commands.m_82127_((String)"smooth_start").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(x -> {
            boolean value;
            processor.getScene((CommandContext<CommandSourceStack>)x).smoothBeginning = value = BoolArgumentType.getBool((CommandContext)x, (String)"value");
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.smooth_beginning", (Object[])new Object[]{value}), false);
            return 0;
        })));
        origin.then(Commands.m_82127_((String)"spinning_fix").then(Commands.m_82129_((String)"mode", (ArgumentType)CamPitchModeArgument.pitchMode()).executes(x -> {
            CamPitchMode mode;
            processor.getScene((CommandContext<CommandSourceStack>)x).pitchMode = mode = CamPitchModeArgument.getMode(x, "mode");
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.pitch_mode", (Object[])new Object[]{mode}), false);
            return 0;
        })));
        origin.then(Commands.m_82127_((String)"distance_timing").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(x -> {
            boolean value;
            processor.getScene((CommandContext<CommandSourceStack>)x).distanceBasedTiming = value = BoolArgumentType.getBool((CommandContext)x, (String)"value");
            processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.distance_timing", (Object[])new Object[]{value}), false);
            return 0;
        })));
        if (processor.requiresSceneName()) {
            original.then((ArgumentBuilder)origin);
        }
    }
}

