/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.command.builder;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;
import team.creative.cmdcam.client.SceneException;
import team.creative.cmdcam.common.command.CamCommandProcessor;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.scene.CamScene;

public class PointArgumentBuilder
extends ArgumentBuilder<CommandSourceStack, PointArgumentBuilder> {
    private final String literal;
    private final TriConsumer<CommandContext<CommandSourceStack>, CamPoint, Integer> indexConsumer;
    private final BiConsumer<CommandContext<CommandSourceStack>, CamPoint> consumer;
    private final CamCommandProcessor processor;

    public PointArgumentBuilder(String literal, TriConsumer<CommandContext<CommandSourceStack>, CamPoint, Integer> consumer, CamCommandProcessor processor) {
        this.literal = literal;
        this.indexConsumer = consumer;
        this.consumer = null;
        this.processor = processor;
    }

    public PointArgumentBuilder(String literal, BiConsumer<CommandContext<CommandSourceStack>, CamPoint> consumer, CamCommandProcessor processor) {
        this.literal = literal;
        this.indexConsumer = null;
        this.consumer = consumer;
        this.processor = processor;
    }

    public String getLiteral() {
        return this.literal;
    }

    protected PointArgumentBuilder getThis() {
        return this;
    }

    private void processPoint(CommandContext<CommandSourceStack> x, CamPoint point) {
        if (this.indexConsumer != null) {
            int index = IntegerArgumentType.getInteger(x, (String)"index") - 1;
            CamScene scene = this.processor.getScene(x);
            if (index >= 0 && index < scene.points.size()) {
                this.indexConsumer.accept(x, (Object)point, (Object)index);
            } else {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237110_((String)"scene.index", (Object[])new Object[]{index + 1}));
            }
        } else {
            this.consumer.accept(x, point);
        }
    }

    public CommandNode<CommandSourceStack> build() {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)this.literal);
        if (this.indexConsumer != null) {
            builder.then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
                if (this.processor.canCreatePoint((CommandContext<CommandSourceStack>)x)) {
                    CamPoint point = this.processor.createPoint((CommandContext<CommandSourceStack>)x);
                    CamScene scene = this.processor.getScene((CommandContext<CommandSourceStack>)x);
                    if (scene.posTarget != null) {
                        try {
                            this.processor.makeRelative(this.processor.getScene((CommandContext<CommandSourceStack>)x), ((CommandSourceStack)x.getSource()).getUnsidedLevel(), point);
                        }
                        catch (SceneException e) {
                            ((CommandSourceStack)x.getSource()).m_81352_(e.getComponent());
                        }
                    }
                    this.processPoint((CommandContext<CommandSourceStack>)x, point);
                }
                return 0;
            }));
        } else {
            builder.executes(x -> {
                if (this.processor.canCreatePoint((CommandContext<CommandSourceStack>)x)) {
                    CamPoint point = this.processor.createPoint((CommandContext<CommandSourceStack>)x);
                    CamScene scene = this.processor.getScene((CommandContext<CommandSourceStack>)x);
                    if (scene.posTarget != null) {
                        try {
                            this.processor.makeRelative(this.processor.getScene((CommandContext<CommandSourceStack>)x), ((CommandSourceStack)x.getSource()).getUnsidedLevel(), point);
                        }
                        catch (SceneException e) {
                            ((CommandSourceStack)x.getSource()).m_81352_(e.getComponent());
                        }
                    }
                    this.processPoint((CommandContext<CommandSourceStack>)x, point);
                }
                return 0;
            });
        }
        builder.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(x -> {
            Vec3 vec = Vec3Argument.m_120844_((CommandContext)x, (String)"location");
            CamPoint point = new CamPoint(vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0, 70.0);
            this.processPoint((CommandContext<CommandSourceStack>)x, point);
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"rotation", (ArgumentType)RotationArgument.m_120479_()).executes(x -> {
            Vec3 vec = Vec3Argument.m_120844_((CommandContext)x, (String)"location");
            Vec2 rotation = RotationArgument.m_120482_((CommandContext)x, (String)"rotation").m_6970_((CommandSourceStack)x.getSource());
            CamPoint point = new CamPoint(vec.f_82479_, vec.f_82480_, vec.f_82481_, rotation.f_82471_, rotation.f_82470_, 0.0, 70.0);
            this.processPoint((CommandContext<CommandSourceStack>)x, point);
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"roll", (ArgumentType)DoubleArgumentType.doubleArg()).executes(x -> {
            Vec3 vec = Vec3Argument.m_120844_((CommandContext)x, (String)"location");
            Vec2 rotation = RotationArgument.m_120482_((CommandContext)x, (String)"rotation").m_6970_((CommandSourceStack)x.getSource());
            CamPoint point = new CamPoint(vec.f_82479_, vec.f_82480_, vec.f_82481_, rotation.f_82471_, rotation.f_82470_, DoubleArgumentType.getDouble((CommandContext)x, (String)"roll"), 70.0);
            this.processPoint((CommandContext<CommandSourceStack>)x, point);
            return 0;
        })).then(Commands.m_82129_((String)"fov", (ArgumentType)DoubleArgumentType.doubleArg()).executes(x -> {
            Vec3 vec = Vec3Argument.m_120844_((CommandContext)x, (String)"location");
            Vec2 rotation = RotationArgument.m_120482_((CommandContext)x, (String)"rotation").m_6970_((CommandSourceStack)x.getSource());
            CamPoint point = new CamPoint(vec.f_82479_, vec.f_82480_, vec.f_82481_, rotation.f_82471_, rotation.f_82470_, DoubleArgumentType.getDouble((CommandContext)x, (String)"roll"), DoubleArgumentType.getDouble((CommandContext)x, (String)"fov"));
            this.processPoint((CommandContext<CommandSourceStack>)x, point);
            return 0;
        })))));
        return builder.build();
    }
}

