/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import team.creative.cmdcam.client.SceneException;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.cmdcam.common.target.CamTarget;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.mc.TickUtils;

public interface CamCommandProcessor {
    public CamScene getScene(CommandContext<CommandSourceStack> var1);

    public boolean canSelectTarget();

    public void selectTarget(CommandContext<CommandSourceStack> var1, boolean var2) throws SceneException;

    default public void setTarget(CommandContext<CommandSourceStack> context, CamTarget target, boolean look) throws SceneException {
        if (look) {
            this.getScene(context).lookTarget = target;
        } else {
            this.checkFollowTarget(context, target != null);
            this.getScene(context).posTarget = target;
        }
    }

    default public void checkFollowTarget(CommandContext<CommandSourceStack> context, boolean shouldFollow) throws SceneException {
        CamScene scene = this.getScene(context);
        if (scene.points.isEmpty()) {
            return;
        }
        if (shouldFollow && scene.posTarget == null) {
            throw new SceneException("scene.follow.absolute_fail");
        }
        if (!shouldFollow && scene.posTarget != null) {
            throw new SceneException("scene.follow.relative_fail");
        }
    }

    public boolean canCreatePoint(CommandContext<CommandSourceStack> var1);

    public CamPoint createPoint(CommandContext<CommandSourceStack> var1);

    default public void makeRelative(CamScene scene, Level level, CamPoint point) throws SceneException {
        if (scene.posTarget != null) {
            Vec3d vec = scene.posTarget.position(level, TickUtils.getFrameTime((LevelAccessor)level));
            if (vec == null) {
                throw new SceneException("scene.follow.not_found");
            }
            point.sub(vec);
        }
    }

    public boolean requiresSceneName();

    public boolean requiresPlayer();

    public void start(CommandContext<CommandSourceStack> var1) throws SceneException;

    public void teleport(CommandContext<CommandSourceStack> var1, int var2);

    public void markDirty(CommandContext<CommandSourceStack> var1);

    public Player getPlayer(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public Entity getEntity(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;
}

