/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.network;

import fuzs.easymagic.client.gui.screens.inventory.ModEnchantmentScreen;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class S2CEnchantingDataMessage
implements MessageV2<S2CEnchantingDataMessage> {
    private int containerId;
    private List<EnchantmentInstance> firstSlotData;
    private List<EnchantmentInstance> secondSlotData;
    private List<EnchantmentInstance> thirdSlotData;

    public S2CEnchantingDataMessage() {
    }

    public S2CEnchantingDataMessage(int containerId, List<EnchantmentInstance> firstSlotData, List<EnchantmentInstance> secondSlotData, List<EnchantmentInstance> thirdSlotData) {
        this.containerId = containerId;
        this.firstSlotData = firstSlotData;
        this.secondSlotData = secondSlotData;
        this.thirdSlotData = thirdSlotData;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.containerId);
        this.writeEnchantmentInstance(buf, this.firstSlotData);
        this.writeEnchantmentInstance(buf, this.secondSlotData);
        this.writeEnchantmentInstance(buf, this.thirdSlotData);
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.readByte();
        this.firstSlotData = this.readEnchantmentInstance(buf);
        this.secondSlotData = this.readEnchantmentInstance(buf);
        this.thirdSlotData = this.readEnchantmentInstance(buf);
    }

    private void writeEnchantmentInstance(FriendlyByteBuf buf, List<EnchantmentInstance> dataList) {
        buf.writeByte(dataList.size());
        for (EnchantmentInstance data : dataList) {
            buf.writeInt(BuiltInRegistries.f_256876_.m_7447_((Object)data.f_44947_));
            buf.writeShort(data.f_44948_);
        }
    }

    private List<EnchantmentInstance> readEnchantmentInstance(FriendlyByteBuf buf) {
        int listSize = buf.readByte();
        ArrayList<EnchantmentInstance> slotData = new ArrayList<EnchantmentInstance>(listSize);
        for (int i = 0; i < listSize; ++i) {
            Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7942_(buf.readInt());
            slotData.add(new EnchantmentInstance(enchantment, (int)buf.readShort()));
        }
        return slotData;
    }

    public MessageV2.MessageHandler<S2CEnchantingDataMessage> makeHandler() {
        return new MessageV2.MessageHandler<S2CEnchantingDataMessage>(){

            public void handle(S2CEnchantingDataMessage message, Player player, Object gameInstance) {
                Screen screen = ((Minecraft)gameInstance).f_91080_;
                if (screen instanceof ModEnchantmentScreen) {
                    ModEnchantmentScreen screen2 = (ModEnchantmentScreen)screen;
                    if (player.f_36096_.f_38840_ == message.containerId) {
                        screen2.setSlotData(0, message.firstSlotData);
                        screen2.setSlotData(1, message.secondSlotData);
                        screen2.setSlotData(2, message.thirdSlotData);
                    }
                }
            }
        };
    }
}

