/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import sculktransporting.registration.STBlocks;
import sculktransporting.registration.STItems;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "sculktransporting", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleParent((Block)STBlocks.SCULK_EMITTER.get(), "sculk_emitter_active");
        this.simpleParent((Block)STBlocks.SCULK_TRANSMITTER.get(), "sculk_transmitter_active");
        this.simpleParent((Block)STBlocks.SCULK_RECEIVER.get(), "sculk_receiver_active");
        this.simpleParent((Block)STBlocks.SCULK_BARREL.get());
        for (RegistryObject item : STItems.ITEMS.getEntries()) {
            this.simpleItem((Item)item.get(), "item/generated");
        }
    }

    public ItemModelBuilder simpleItem(Item item, String parent) {
        String path = this.name(item);
        return this.uncheckedSingleTexture(path, this.mcLoc(parent), "layer0", this.modLoc("item/" + path));
    }

    public ItemModelBuilder uncheckedSingleTexture(String name, ResourceLocation parent, String textureKey, ResourceLocation texture) {
        return (ItemModelBuilder)this.parent(name, parent).texture(textureKey, texture);
    }

    public ItemModelBuilder simpleParent(Block block) {
        return this.simpleParent(block, this.name(block));
    }

    public ItemModelBuilder simpleParent(Block block, String parent) {
        return this.parent(this.name(block), this.modLoc("block/" + parent));
    }

    public ItemModelBuilder parent(String name, ResourceLocation parent) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(parent));
    }

    private String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    private String name(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    public String m_6055_() {
        return "sculktransporting Item Models";
    }
}

