/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.datagen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sculktransporting.datagen.BlockLootTableGenerator;
import sculktransporting.datagen.BlockTagGenerator;
import sculktransporting.datagen.ItemModelGenerator;
import sculktransporting.datagen.ItemTagGenerator;
import sculktransporting.datagen.RecipeGenerator;

@Mod.EventBusSubscriber(modid="sculktransporting", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenRegistrar {
    private DataGenRegistrar() {
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = new ExistingFileHelper(Collections.emptyList(), Collections.emptySet(), false, null, null);
        BlockTagGenerator blockTagGenerator = new BlockTagGenerator(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTableGenerator::new, LootContextParamSets.f_81421_))));
        generator.addProvider(event.includeServer(), (DataProvider)blockTagGenerator);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(output, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(output));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Sculk Transporting resources & data"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
    }
}

