/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;
import sculktransporting.client.ClientHandler;
import sculktransporting.items.SpeedModifierItem;

public class SculkReceiverModel
implements IDynamicBakedModel {
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private BakedModel originalModel;
    private Map<Pair<Direction, SpeedModifierItem.SpeedTier>, List<BakedQuad>> quadCache = new ConcurrentHashMap<Pair<Direction, SpeedModifierItem.SpeedTier>, List<BakedQuad>>();

    public SculkReceiverModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        SpeedModifierItem.SpeedTier speedTier;
        if (side != null && (speedTier = (SpeedModifierItem.SpeedTier)data.get(ClientHandler.SPEED_TIER)) != null) {
            return this.quadCache.computeIfAbsent((Pair<Direction, SpeedModifierItem.SpeedTier>)Pair.of((Object)side, (Object)speedTier), k -> {
                ArrayList<BakedQuad> originalQuads = new ArrayList<BakedQuad>(this.originalModel.getQuads(state, side, rand, data, renderType));
                for (int i = 0; i < originalQuads.size(); ++i) {
                    BakedQuad quad = (BakedQuad)originalQuads.get(i);
                    if (quad.m_111305_() != 0) continue;
                    Direction quadDirection = quad.m_111306_();
                    if (quadDirection == Direction.NORTH) {
                        originalQuads.set(i, this.bakeQuad(new Vector3f(0.0f, 3.0f, 0.0f), new Vector3f(16.0f, 8.0f, 0.0f), speedTier, quad));
                        continue;
                    }
                    if (quadDirection == Direction.EAST) {
                        originalQuads.set(i, this.bakeQuad(new Vector3f(16.0f, 3.0f, 0.0f), new Vector3f(16.0f, 8.0f, 16.0f), speedTier, quad));
                        continue;
                    }
                    if (quadDirection == Direction.SOUTH) {
                        originalQuads.set(i, this.bakeQuad(new Vector3f(0.0f, 3.0f, 16.0f), new Vector3f(16.0f, 8.0f, 16.0f), speedTier, quad));
                        continue;
                    }
                    if (quadDirection != Direction.WEST) continue;
                    originalQuads.set(i, this.bakeQuad(new Vector3f(0.0f, 3.0f, 0.0f), new Vector3f(0.0f, 8.0f, 16.0f), speedTier, quad));
                }
                return originalQuads;
            });
        }
        return this.originalModel.getQuads(state, side, rand, data, renderType);
    }

    private BakedQuad bakeQuad(Vector3f from, Vector3f to, SpeedModifierItem.SpeedTier speedTier, BakedQuad originalQuad) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("sculktransporting", "block/sculk_receiver_side_" + speedTier.getValue()));
        return FACE_BAKERY.m_111600_(from, to, new BlockElementFace(null, originalQuad.m_111305_(), sprite.m_245424_().m_246162_().toString(), new BlockFaceUV(new float[]{0.0f, 8.0f, 16.0f, 13.0f}, 0)), sprite, originalQuad.m_111306_(), (ModelState)BlockModelRotation.X0_Y0, null, originalQuad.m_111307_(), new ResourceLocation("sculktransporting", "sculk_receiver"));
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.originalModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.originalModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.originalModel.m_7343_();
    }
}

