/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;
import sculktransporting.client.ClientHandler;
import sculktransporting.items.ModifierTier;
import sculktransporting.items.QuantityModifierItem;
import sculktransporting.items.SpeedModifierItem;

public class SculkEmitterModel
implements IDynamicBakedModel {
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private BakedModel originalModel;
    private Map<CacheKey, List<BakedQuad>> quadCache = new ConcurrentHashMap<CacheKey, List<BakedQuad>>();

    public SculkEmitterModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        if (side != null) {
            SpeedModifierItem.SpeedTier speedTier = (SpeedModifierItem.SpeedTier)data.get(ClientHandler.SPEED_TIER);
            QuantityModifierItem.QuantityTier quantityTier = (QuantityModifierItem.QuantityTier)data.get(ClientHandler.QUANTITY_TIER);
            if (speedTier != null && quantityTier != null) {
                return this.quadCache.computeIfAbsent(new CacheKey(side, speedTier, quantityTier), k -> {
                    ArrayList<BakedQuad> originalQuads = new ArrayList<BakedQuad>(this.originalModel.getQuads(state, side, rand, data, renderType));
                    for (int i = 0; i < originalQuads.size(); ++i) {
                        BakedQuad quad = (BakedQuad)originalQuads.get(i);
                        if (!quad.m_111304_()) continue;
                        int tintIndex = quad.m_111305_();
                        if (quad.m_111306_() == Direction.NORTH) {
                            if (tintIndex == 0) {
                                originalQuads.set(i, this.bakeLeftQuad(new Vector3f(8.0f, 0.0f, 0.0f), new Vector3f(16.0f, 8.0f, 0.0f), speedTier, quad));
                                continue;
                            }
                            if (tintIndex != 1) continue;
                            originalQuads.set(i, this.bakeRightQuad(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(8.0f, 8.0f, 0.0f), quantityTier, quad));
                            continue;
                        }
                        if (quad.m_111306_() == Direction.EAST) {
                            if (tintIndex == 0) {
                                originalQuads.set(i, this.bakeLeftQuad(new Vector3f(16.0f, 0.0f, 8.0f), new Vector3f(16.0f, 8.0f, 16.0f), speedTier, quad));
                                continue;
                            }
                            if (tintIndex != 1) continue;
                            originalQuads.set(i, this.bakeRightQuad(new Vector3f(16.0f, 0.0f, 0.0f), new Vector3f(16.0f, 8.0f, 8.0f), quantityTier, quad));
                            continue;
                        }
                        if (quad.m_111306_() == Direction.SOUTH) {
                            if (tintIndex == 0) {
                                originalQuads.set(i, this.bakeLeftQuad(new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(8.0f, 8.0f, 16.0f), speedTier, quad));
                                continue;
                            }
                            if (tintIndex != 1) continue;
                            originalQuads.set(i, this.bakeRightQuad(new Vector3f(8.0f, 0.0f, 16.0f), new Vector3f(16.0f, 8.0f, 16.0f), quantityTier, quad));
                            continue;
                        }
                        if (quad.m_111306_() != Direction.WEST) continue;
                        if (tintIndex == 0) {
                            originalQuads.set(i, this.bakeLeftQuad(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 8.0f, 8.0f), speedTier, quad));
                            continue;
                        }
                        if (tintIndex != 1) continue;
                        originalQuads.set(i, this.bakeRightQuad(new Vector3f(0.0f, 0.0f, 8.0f), new Vector3f(0.0f, 8.0f, 16.0f), quantityTier, quad));
                    }
                    return originalQuads;
                });
            }
        }
        return this.originalModel.getQuads(state, side, rand, data, renderType);
    }

    private BakedQuad bakeLeftQuad(Vector3f from, Vector3f to, ModifierTier modifierTier, BakedQuad originalQuad) {
        return this.bakeQuad(from, to, modifierTier, originalQuad, 0.0f, 8.0f, 8.0f, 16.0f);
    }

    private BakedQuad bakeRightQuad(Vector3f from, Vector3f to, ModifierTier modifierTier, BakedQuad originalQuad) {
        return this.bakeQuad(from, to, modifierTier, originalQuad, 8.0f, 8.0f, 16.0f, 16.0f);
    }

    private BakedQuad bakeQuad(Vector3f from, Vector3f to, ModifierTier modifierTier, BakedQuad originalQuad, float u0, float u1, float v0, float v1) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("sculktransporting", "block/sculk_emitter_side_" + modifierTier.getValue()));
        return FACE_BAKERY.m_111600_(from, to, new BlockElementFace(null, originalQuad.m_111305_(), sprite.m_245424_().m_246162_().toString(), new BlockFaceUV(new float[]{u0, u1, v0, v1}, 0)), sprite, originalQuad.m_111306_(), (ModelState)BlockModelRotation.X0_Y0, null, originalQuad.m_111307_(), new ResourceLocation("sculktransporting", "sculk_emitter"));
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.originalModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.originalModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.originalModel.m_7343_();
    }

    record CacheKey(Direction side, SpeedModifierItem.SpeedTier speedTier, QuantityModifierItem.QuantityTier quantityTier) {
    }
}

