/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import java.util.stream.Collectors;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import sculktransporting.client.ItemSignalParticle;
import sculktransporting.client.SculkEmitterModel;
import sculktransporting.client.SculkItemTransporterBlockEntityRenderer;
import sculktransporting.client.SculkReceiverModel;
import sculktransporting.client.SculkTransmitterBlockEntityRenderer;
import sculktransporting.items.QuantityModifierItem;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;
import sculktransporting.registration.STBlocks;
import sculktransporting.registration.STParticleTypes;

@Mod.EventBusSubscriber(modid="sculktransporting", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    public static final ModelProperty<SpeedModifierItem.SpeedTier> SPEED_TIER = new ModelProperty();
    public static final ModelProperty<QuantityModifierItem.QuantityTier> QUANTITY_TIER = new ModelProperty();

    private ClientHandler() {
    }

    @SubscribeEvent
    public static void onModelBakingCompleted(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation mrl;
        String stateString;
        Block sculkReceiver = (Block)STBlocks.SCULK_RECEIVER.get();
        Block sculkEmitter = (Block)STBlocks.SCULK_EMITTER.get();
        for (BlockState state : sculkReceiver.m_49965_().m_61056_()) {
            stateString = state.m_61148_().entrySet().stream().map(StateHolder.f_61110_).collect(Collectors.joining(","));
            mrl = new ModelResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)sculkReceiver), stateString);
            event.getModels().put(mrl, new SculkReceiverModel((BakedModel)event.getModels().get(mrl)));
        }
        for (BlockState state : sculkEmitter.m_49965_().m_61056_()) {
            stateString = state.m_61148_().entrySet().stream().map(StateHolder.f_61110_).collect(Collectors.joining(","));
            mrl = new ModelResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)sculkEmitter), stateString);
            event.getModels().put(mrl, new SculkEmitterModel((BakedModel)event.getModels().get(mrl)));
        }
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)STBlockEntityTypes.SCULK_EMITTER_BLOCK_ENTITY.get(), SculkItemTransporterBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)STBlockEntityTypes.SCULK_TRANSMITTER_BLOCK_ENTITY.get(), SculkTransmitterBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)STBlockEntityTypes.SCULK_RECEIVER_BLOCK_ENTITY.get(), SculkItemTransporterBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)STParticleTypes.ITEM_SIGNAL.get(), (ParticleProvider)new ItemSignalParticle.Provider());
    }
}

