/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blocks;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sculktransporting.STTags;
import sculktransporting.blockentities.SculkReceiverBlockEntity;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;

public class SculkReceiverBlock
extends BaseSculkItemTransporterBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)3.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)3.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)1.0), Block.m_49796_((double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public SculkReceiverBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SculkReceiverBlockEntity) {
            SculkReceiverBlockEntity be = (SculkReceiverBlockEntity)blockEntity;
            ItemStack heldStack = player.m_21120_(hand);
            if (heldStack.m_204117_(STTags.Items.SPEED_MODIFIERS)) {
                if (!level.f_46443_ && be.getSpeedTier() == SpeedModifierItem.SpeedTier.ZERO && be.setSpeedTier(((SpeedModifierItem)heldStack.m_41720_()).tier) && !player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (player.m_6144_()) {
                if (!level.f_46443_) {
                    SpeedModifierItem.SpeedTier speedTier = be.getSpeedTier();
                    be.removeSpeedModifier();
                    player.m_150109_().m_150079_(new ItemStack((ItemLike)speedTier.getItem()));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (fromPos.m_123342_() == pos.m_123342_() - 1 && (blockEntity = level.m_7702_(pos)) instanceof SculkReceiverBlockEntity) {
            SculkReceiverBlockEntity be = (SculkReceiverBlockEntity)blockEntity;
            BlockState stateBelow = level.m_8055_(fromPos);
            if (be.getLastKnownStateBelow() != stateBelow) {
                be.forgetInventoryBelow(stateBelow);
            }
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof SculkReceiverBlockEntity) {
            SculkReceiverBlockEntity be = (SculkReceiverBlockEntity)blockEntity;
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)be.getSpeedTier().getItem()));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SculkReceiverBlockEntity(pos, state);
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.f_46443_ ? SculkReceiverBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)STBlockEntityTypes.SCULK_RECEIVER_BLOCK_ENTITY.get()), SculkReceiverBlockEntity::serverTick) : null;
    }
}

