/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import sculktransporting.STTags;
import sculktransporting.blockentities.SculkEmitterBlockEntity;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.items.QuantityModifierItem;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;

public class SculkEmitterBlock
extends BaseSculkItemTransporterBlock {
    public SculkEmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SculkEmitterBlockEntity) {
            Direction clickedFace;
            SculkEmitterBlockEntity be = (SculkEmitterBlockEntity)blockEntity;
            ItemStack heldStack = player.m_21120_(hand);
            boolean isQuantityModifier = heldStack.m_204117_(STTags.Items.QUANTITY_MODIFIERS);
            if (isQuantityModifier || heldStack.m_204117_(STTags.Items.SPEED_MODIFIERS)) {
                if (!level.f_46443_) {
                    boolean modifierAdded = false;
                    if (isQuantityModifier && be.getQuantityTier() == QuantityModifierItem.QuantityTier.ZERO) {
                        modifierAdded = be.setQuantityTier(((QuantityModifierItem)heldStack.m_41720_()).tier);
                    }
                    if (!isQuantityModifier && be.getSpeedTier() == SpeedModifierItem.SpeedTier.ZERO) {
                        modifierAdded = be.setSpeedTier(((SpeedModifierItem)heldStack.m_41720_()).tier);
                    }
                    if (modifierAdded && !player.m_7500_()) {
                        heldStack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (player.m_6144_() && (clickedFace = hit.m_82434_()).m_122434_().m_122479_()) {
                if (!level.f_46443_) {
                    double hitX = Mth.m_14185_((double)hit.m_82450_().f_82479_);
                    double hitZ = Mth.m_14185_((double)hit.m_82450_().f_82481_);
                    if (clickedFace == Direction.NORTH) {
                        this.removeModifer(player, be, hitX < 0.5);
                    } else if (clickedFace == Direction.SOUTH) {
                        this.removeModifer(player, be, hitX >= 0.5);
                    } else if (clickedFace == Direction.EAST) {
                        this.removeModifer(player, be, hitZ < 0.5);
                    } else if (clickedFace == Direction.WEST) {
                        this.removeModifer(player, be, hitZ >= 0.5);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private void removeModifer(Player player, SculkEmitterBlockEntity be, boolean removeQuantityModifier) {
        Enum modifierTier;
        if (removeQuantityModifier) {
            modifierTier = be.getQuantityTier();
            be.removeQuantityModifier();
        } else {
            modifierTier = be.getSpeedTier();
            be.removeSpeedModifier();
        }
        player.m_150109_().m_150079_(new ItemStack((ItemLike)modifierTier.getItem()));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (fromPos.m_123342_() == pos.m_123342_() - 1 && (blockEntity = level.m_7702_(pos)) instanceof SculkEmitterBlockEntity) {
            SculkEmitterBlockEntity be = (SculkEmitterBlockEntity)blockEntity;
            BlockState stateBelow = level.m_8055_(fromPos);
            if (be.getLastKnownStateBelow() != stateBelow) {
                be.forgetInventoryBelow(stateBelow);
            }
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof SculkEmitterBlockEntity) {
            SculkEmitterBlockEntity be = (SculkEmitterBlockEntity)blockEntity;
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)be.getSpeedTier().getItem()));
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)be.getQuantityTier().getItem()));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SculkEmitterBlockEntity(pos, state);
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.f_46443_ ? SculkEmitterBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)STBlockEntityTypes.SCULK_EMITTER_BLOCK_ENTITY.get()), SculkEmitterBlockEntity::serverTick) : null;
    }
}

