/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blockentities;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import sculktransporting.blockentities.BaseSculkItemTransporterBlockEntity;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.client.ClientHandler;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;

public class SculkReceiverBlockEntity
extends BaseSculkItemTransporterBlockEntity {
    private BlockState lastKnownStateBelow;
    private LazyOptional<IItemHandler> inventoryBelow;
    private SpeedModifierItem.SpeedTier speedTier = SpeedModifierItem.SpeedTier.ZERO;

    public SculkReceiverBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SculkReceiverBlockEntity be) {
        VibrationSystem.Ticker.m_280259_((Level)level, (VibrationSystem.Data)be.m_280002_(), (VibrationSystem.User)be.m_280445_());
        if (level.m_46467_() % 5L == 0L && be.inventoryBelow == null) {
            BlockEntity beBelow = level.m_7702_(pos.m_7495_());
            be.inventoryBelow = beBelow != null ? beBelow.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP) : LazyOptional.empty();
        }
        if (be.shouldPerformAction(level) && be.hasStoredItemSignal() && be.inventoryBelow != null) {
            be.inventoryBelow.ifPresent(itemHandler -> {
                ItemStack inserted = be.storedItemSignal;
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    if (!(inserted = itemHandler.insertItem(i, inserted, false)).m_41619_()) continue;
                    be.storedItemSignal = ItemStack.f_41583_;
                    BaseSculkItemTransporterBlock.m_154407_(level, be.f_58858_, be.m_58900_());
                    break;
                }
                be.storedItemSignal = inserted;
            });
        }
    }

    @Override
    public boolean shouldPerformAction(Level level) {
        return this.speedTier == SpeedModifierItem.SpeedTier.FOUR || level.m_46467_() % (long)(20 - this.speedTier.getValue() * 5) == 0L;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.speedTier = SpeedModifierItem.SpeedTier.values()[tag.m_128451_("SpeedTier")];
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SpeedTier", this.speedTier.ordinal());
    }

    public boolean setSpeedTier(SpeedModifierItem.SpeedTier speedTier) {
        if (this.speedTier == speedTier) {
            return false;
        }
        this.speedTier = speedTier;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return true;
    }

    public void removeSpeedModifier() {
        if (this.speedTier == SpeedModifierItem.SpeedTier.ZERO) {
            return;
        }
        this.setSpeedTier(SpeedModifierItem.SpeedTier.ZERO);
    }

    public SpeedModifierItem.SpeedTier getSpeedTier() {
        return this.speedTier;
    }

    public BlockState getLastKnownStateBelow() {
        return this.lastKnownStateBelow;
    }

    public void forgetInventoryBelow(BlockState stateBelow) {
        this.inventoryBelow = null;
        this.lastKnownStateBelow = stateBelow;
    }

    @Override
    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)STBlockEntityTypes.SCULK_RECEIVER_BLOCK_ENTITY.get();
    }

    public ModelData getModelData() {
        return ModelData.builder().with(ClientHandler.SPEED_TIER, (Object)this.speedTier).build();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.requestModelDataUpdate();
        Minecraft.m_91087_().f_91060_.m_109494_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
    }
}

