/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blockentities;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import sculktransporting.STTags;
import sculktransporting.blockentities.BaseSculkItemTransporterBlockEntity;
import sculktransporting.client.ClientHandler;
import sculktransporting.items.QuantityModifierItem;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;

public class SculkEmitterBlockEntity
extends BaseSculkItemTransporterBlockEntity {
    private BlockState lastKnownStateBelow;
    private LazyOptional<IItemHandler> inventoryBelow;
    private QuantityModifierItem.QuantityTier quantityTier = QuantityModifierItem.QuantityTier.ZERO;
    private SpeedModifierItem.SpeedTier speedTier = SpeedModifierItem.SpeedTier.ZERO;

    public SculkEmitterBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SculkEmitterBlockEntity be) {
        if (level.m_46467_() % 5L == 0L && be.inventoryBelow == null) {
            BlockEntity beBelow = level.m_7702_(pos.m_7495_());
            be.inventoryBelow = beBelow != null && beBelow.m_58900_().m_204336_(STTags.Blocks.SCULK_EMITTER_CAN_EXTRACT_FROM) ? beBelow.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP) : LazyOptional.empty();
        }
        if (be.shouldPerformAction(level)) {
            if (!be.hasStoredItemSignal() && be.inventoryBelow != null) {
                be.inventoryBelow.ifPresent(itemHandler -> {
                    int amountToExtract = (int)Math.pow(4.0, be.quantityTier.getValue());
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack extracted = itemHandler.extractItem(i, amountToExtract, false);
                        if (extracted.m_41619_()) continue;
                        be.setItemSignal(new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), extracted), 15);
                        break;
                    }
                });
            }
            BaseSculkItemTransporterBlockEntity.serverTick(level, pos, state, be);
        }
    }

    @Override
    public VibrationSystem.User m_280175_() {
        return new SculkEmitterVibrationUser(this.m_58899_());
    }

    @Override
    public boolean shouldPerformAction(Level level) {
        return this.speedTier == SpeedModifierItem.SpeedTier.FOUR || level.m_46467_() % (long)(20 - this.speedTier.getValue() * 5) == 0L;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.quantityTier = QuantityModifierItem.QuantityTier.values()[tag.m_128451_("QuantityTier")];
        this.speedTier = SpeedModifierItem.SpeedTier.values()[tag.m_128451_("SpeedTier")];
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("QuantityTier", this.quantityTier.ordinal());
        tag.m_128405_("SpeedTier", this.speedTier.ordinal());
    }

    public boolean setQuantityTier(QuantityModifierItem.QuantityTier quantityTier) {
        if (this.quantityTier == quantityTier) {
            return false;
        }
        this.quantityTier = quantityTier;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return true;
    }

    public void removeQuantityModifier() {
        if (this.quantityTier == QuantityModifierItem.QuantityTier.ZERO) {
            return;
        }
        this.setQuantityTier(QuantityModifierItem.QuantityTier.ZERO);
    }

    public QuantityModifierItem.QuantityTier getQuantityTier() {
        return this.quantityTier;
    }

    public boolean setSpeedTier(SpeedModifierItem.SpeedTier speedTier) {
        if (this.speedTier == speedTier) {
            return false;
        }
        this.speedTier = speedTier;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return true;
    }

    public void removeSpeedModifier() {
        if (this.speedTier == SpeedModifierItem.SpeedTier.ZERO) {
            return;
        }
        this.setSpeedTier(SpeedModifierItem.SpeedTier.ZERO);
    }

    public SpeedModifierItem.SpeedTier getSpeedTier() {
        return this.speedTier;
    }

    public BlockState getLastKnownStateBelow() {
        return this.lastKnownStateBelow;
    }

    public void forgetInventoryBelow(BlockState stateBelow) {
        this.inventoryBelow = null;
        this.lastKnownStateBelow = stateBelow;
    }

    @Override
    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)STBlockEntityTypes.SCULK_EMITTER_BLOCK_ENTITY.get();
    }

    public ModelData getModelData() {
        return ModelData.builder().with(ClientHandler.SPEED_TIER, (Object)this.speedTier).with(ClientHandler.QUANTITY_TIER, (Object)this.quantityTier).build();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.requestModelDataUpdate();
        Minecraft.m_91087_().f_91060_.m_109494_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
    }

    public class SculkEmitterVibrationUser
    extends BaseSculkItemTransporterBlockEntity.BaseVibrationUser {
        public SculkEmitterVibrationUser(BlockPos pos) {
            super(pos);
        }

        @Override
        public boolean m_280612_(GameEvent gameEvent, GameEvent.Context ctx) {
            return false;
        }

        @Override
        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, GameEvent.Context ctx) {
            return false;
        }

        @Override
        public void m_280022_() {
        }

        @Override
        public void m_280271_(ServerLevel level, BlockPos pos, GameEvent event, Entity entity, Entity projectileOwner, float distance) {
        }
    }
}

