/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.client.ItemSignalParticleOption;
import sculktransporting.misc.OneReceiverVibrationListener;
import sculktransporting.registration.STGameEvents;

public abstract class BaseSculkItemTransporterBlockEntity
extends SculkSensorBlockEntity {
    protected ItemStack storedItemSignal = ItemStack.f_41583_;
    protected BlockPos signalOrigin;
    protected ItemEntity cachedItemEntity;

    protected BaseSculkItemTransporterBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
        this.f_279626_ = new OneReceiverVibrationListener((VibrationSystem)this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BaseSculkItemTransporterBlockEntity be) {
        VibrationSystem.Ticker.m_280259_((Level)level, (VibrationSystem.Data)be.m_280002_(), (VibrationSystem.User)be.m_280445_());
        if (!be.storedItemSignal.m_41619_()) {
            if (be.cachedItemEntity == null) {
                be.f_58857_.m_46672_(pos, state.m_60734_());
                be.cachedItemEntity = new ItemEntity(level, (double)be.signalOrigin.m_123341_(), (double)be.signalOrigin.m_123342_(), (double)be.signalOrigin.m_123343_(), be.storedItemSignal);
            }
            if (be.shouldPerformAction(level) && be.cachedItemEntity.m_6084_()) {
                level.m_142346_((Entity)be.cachedItemEntity, (GameEvent)STGameEvents.ITEM_TRANSMITTABLE.get(), pos);
            }
        }
    }

    public VibrationSystem.User m_280175_() {
        return new BaseVibrationUser(this.m_58899_());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storedItemSignal = ItemStack.m_41712_((CompoundTag)tag.m_128469_("StoredItemSignal"));
        this.signalOrigin = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("SignalOrigin"));
    }

    protected void m_183515_(CompoundTag tag) {
        Entity entity;
        super.m_183515_(tag);
        if (!this.storedItemSignal.m_41619_()) {
            tag.m_128365_("StoredItemSignal", (Tag)this.storedItemSignal.m_41739_(new CompoundTag()));
            tag.m_128365_("SignalOrigin", (Tag)NbtUtils.m_129224_((BlockPos)this.signalOrigin));
        } else if (this.m_280002_().m_280602_() != null && (entity = this.m_280002_().m_280602_().f_244048_()) instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            tag.m_128365_("StoredItemSignal", (Tag)item.m_32055_().m_41739_(new CompoundTag()));
            tag.m_128365_("SignalOrigin", (Tag)NbtUtils.m_129224_((BlockPos)item.m_20183_()));
        }
    }

    public abstract boolean shouldPerformAction(Level var1);

    public boolean hasStoredItemSignal() {
        return !this.storedItemSignal.m_41619_();
    }

    public ItemStack getStoredItemSignal() {
        return this.storedItemSignal;
    }

    public void setItemSignal(ItemEntity itemSignal, int power) {
        if (itemSignal == null) {
            this.storedItemSignal = ItemStack.f_41583_;
            this.signalOrigin = null;
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        } else {
            Block block;
            boolean shouldActivate = this.storedItemSignal.m_41619_();
            this.storedItemSignal = itemSignal.m_32055_().m_41777_();
            this.signalOrigin = itemSignal.m_20183_();
            if (shouldActivate && (block = this.m_58900_().m_60734_()) instanceof BaseSculkItemTransporterBlock) {
                BaseSculkItemTransporterBlock sculkItemTransporterBlock = (BaseSculkItemTransporterBlock)block;
                sculkItemTransporterBlock.m_277033_((Entity)itemSignal, this.f_58857_, this.f_58858_, this.m_58900_(), power, 0);
            }
        }
        this.cachedItemEntity = null;
    }

    public abstract BlockEntityType<?> m_58903_();

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public class BaseVibrationUser
    extends SculkSensorBlockEntity.VibrationUser {
        public BaseVibrationUser(BlockPos pos) {
            super((SculkSensorBlockEntity)BaseSculkItemTransporterBlockEntity.this, pos);
        }

        public boolean m_280612_(GameEvent gameEvent, GameEvent.Context ctx) {
            ItemEntity item;
            Entity entity;
            return gameEvent == STGameEvents.ITEM_TRANSMITTABLE.get() && (entity = ctx.f_223711_()) instanceof ItemEntity && (item = (ItemEntity)entity).m_6084_();
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, GameEvent.Context ctx) {
            ItemEntity item;
            Entity entity;
            return BaseSculkItemTransporterBlockEntity.this.storedItemSignal.m_41619_() && (entity = ctx.f_223711_()) instanceof ItemEntity && !(item = (ItemEntity)entity).m_20183_().equals((Object)BaseSculkItemTransporterBlockEntity.this.f_58858_) && super.m_280080_(level, pos, event, ctx);
        }

        public void m_280022_() {
            Entity entity;
            super.m_280022_();
            if (BaseSculkItemTransporterBlockEntity.this.m_280002_().m_280602_() != null && (entity = BaseSculkItemTransporterBlockEntity.this.m_280002_().m_280602_().f_244048_()) instanceof ItemEntity) {
                BaseSculkItemTransporterBlockEntity be;
                ItemEntity item = (ItemEntity)entity;
                Vec3 originVec = BaseSculkItemTransporterBlockEntity.this.m_280002_().m_280602_().f_243906_();
                BlockPos originPos = BlockPos.m_274446_((Position)originVec);
                BlockEntity blockEntity = BaseSculkItemTransporterBlockEntity.this.f_58857_.m_7702_(originPos);
                if (blockEntity instanceof BaseSculkItemTransporterBlockEntity && (be = (BaseSculkItemTransporterBlockEntity)blockEntity).hasStoredItemSignal() && be.getStoredItemSignal() == item.m_32055_()) {
                    be.setItemSignal(null, 0);
                    BaseSculkItemTransporterBlockEntity.this.f_58857_.m_186460_(originPos, be.m_58900_().m_60734_(), 0);
                    item.m_146884_(originVec);
                    ((ServerLevel)BaseSculkItemTransporterBlockEntity.this.f_58857_).m_8767_((ParticleOptions)new ItemSignalParticleOption(BaseSculkItemTransporterBlockEntity.this.m_280052_().m_142460_(), BaseSculkItemTransporterBlockEntity.this.m_280002_().m_280274_(), item.m_32055_()), originVec.f_82479_, originVec.f_82480_, originVec.f_82481_, (item.m_32055_().m_41613_() + 15) / 16 * 5, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        public void m_280271_(ServerLevel level, BlockPos pos, GameEvent event, Entity entity, Entity projectileOwner, float distance) {
            super.m_280271_(level, pos, event, entity, projectileOwner, distance);
            if (event == STGameEvents.ITEM_TRANSMITTABLE.get() && entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                BaseSculkItemTransporterBlockEntity.this.setItemSignal(item, VibrationSystem.m_280007_((float)distance, (int)this.m_280351_()));
            }
        }
    }
}

