/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.google.common.collect.Lists;
import com.supermartijn642.core.util.MappedSetView;
import com.supermartijn642.core.util.Pair;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class Registries {
    static final Map<ResourceLocation, Registry<?>> IDENTIFIER_TO_REGISTRY = new HashMap();
    static final Map<net.minecraft.core.Registry<?>, Registry<?>> VANILLA_REGISTRY_MAP = new HashMap();
    static final Map<IForgeRegistry<?>, Registry<?>> FORGE_REGISTRY_MAP = new HashMap();
    static final Map<Registry<?>, List<Registry<?>>> REGISTRATION_ORDER_MAP = new HashMap();
    public static final Registry<Block> BLOCKS = Registries.forge(BuiltInRegistries.f_256975_, ForgeRegistries.BLOCKS, Block.class);
    public static final Registry<Fluid> FLUIDS = Registries.forge(BuiltInRegistries.f_257020_, ForgeRegistries.FLUIDS, Fluid.class);
    public static final Registry<Item> ITEMS = Registries.forge(BuiltInRegistries.f_257033_, ForgeRegistries.ITEMS, Item.class);
    public static final Registry<MobEffect> MOB_EFFECTS = Registries.forge(BuiltInRegistries.f_256974_, ForgeRegistries.MOB_EFFECTS, MobEffect.class);
    public static final Registry<SoundEvent> SOUND_EVENTS = Registries.forge(BuiltInRegistries.f_256894_, ForgeRegistries.SOUND_EVENTS, SoundEvent.class);
    public static final Registry<Potion> POTIONS = Registries.forge(BuiltInRegistries.f_256980_, ForgeRegistries.POTIONS, Potion.class);
    public static final Registry<Enchantment> ENCHANTMENTS = Registries.forge(BuiltInRegistries.f_256876_, ForgeRegistries.ENCHANTMENTS, Enchantment.class);
    public static final Registry<EntityType<?>> ENTITY_TYPES = Registries.forge(BuiltInRegistries.f_256780_, ForgeRegistries.ENTITY_TYPES, EntityType.class);
    public static final Registry<BlockEntityType<?>> BLOCK_ENTITY_TYPES = Registries.forge(BuiltInRegistries.f_257049_, ForgeRegistries.BLOCK_ENTITY_TYPES, BlockEntityType.class);
    public static final Registry<ParticleType<?>> PARTICLE_TYPES = Registries.forge(BuiltInRegistries.f_257034_, ForgeRegistries.PARTICLE_TYPES, ParticleType.class);
    public static final Registry<MenuType<?>> MENU_TYPES = Registries.forge(BuiltInRegistries.f_256818_, ForgeRegistries.MENU_TYPES, MenuType.class);
    public static final Registry<PaintingVariant> PAINTING_VARIANTS = Registries.forge(BuiltInRegistries.f_257051_, ForgeRegistries.PAINTING_VARIANTS, PaintingVariant.class);
    public static final Registry<RecipeType<?>> RECIPE_TYPES = Registries.forge(BuiltInRegistries.f_256990_, ForgeRegistries.RECIPE_TYPES, RecipeType.class);
    public static final Registry<RecipeSerializer<?>> RECIPE_SERIALIZERS = Registries.forge(BuiltInRegistries.f_256769_, ForgeRegistries.RECIPE_SERIALIZERS, RecipeSerializer.class);
    public static final Registry<Attribute> ATTRIBUTES = Registries.forge(BuiltInRegistries.f_256951_, ForgeRegistries.ATTRIBUTES, Attribute.class);
    public static final Registry<StatType<?>> STAT_TYPES = Registries.forge(BuiltInRegistries.f_256899_, ForgeRegistries.STAT_TYPES, StatType.class);
    public static final Registry<IConditionSerializer<?>> RECIPE_CONDITION_SERIALIZERS = new RecipeConditionSerializerRegistry();

    private static void addRegistry(Registry<?> registry) {
        if (IDENTIFIER_TO_REGISTRY.containsKey(registry.getRegistryIdentifier())) {
            throw new RuntimeException("Duplicate registry registration for identifier '" + registry.getRegistryIdentifier() + "'!");
        }
        if (registry.hasVanillaRegistry() && VANILLA_REGISTRY_MAP.containsKey(registry.getVanillaRegistry())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + registry.getValueClass() + "'!");
        }
        if (registry.hasForgeRegistry() && FORGE_REGISTRY_MAP.containsKey(registry.getForgeRegistry())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + registry.getValueClass() + "'!");
        }
        IDENTIFIER_TO_REGISTRY.put(registry.getRegistryIdentifier(), registry);
        if (registry.hasVanillaRegistry()) {
            VANILLA_REGISTRY_MAP.put(registry.getVanillaRegistry(), registry);
        }
        if (registry.hasForgeRegistry()) {
            FORGE_REGISTRY_MAP.put(registry.getForgeRegistry(), registry);
        }
    }

    @Deprecated
    @ApiStatus.Internal
    public static void onRecipeConditionSerializerAdded(IConditionSerializer<?> serializer) {
        ((RecipeConditionSerializerRegistry)RECIPE_CONDITION_SERIALIZERS).onObjectAdded(serializer);
    }

    @Deprecated
    public static <T> Registry<T> fromUnderlying(net.minecraft.core.Registry<T> registry) {
        return VANILLA_REGISTRY_MAP.get(registry);
    }

    @Deprecated
    public static <T> Registry<T> fromUnderlying(IForgeRegistry<T> registry) {
        return FORGE_REGISTRY_MAP.get(registry);
    }

    public static Registry<?> getRegistry(ResourceLocation identifier) {
        return IDENTIFIER_TO_REGISTRY.get(identifier);
    }

    private static <T> Registry<T> vanilla(net.minecraft.core.Registry<T> registry, Class<? super T> valueClass) {
        return new VanillaRegistryWrapper<T>(registry, valueClass);
    }

    private static <T> Registry<T> forge(net.minecraft.core.Registry<T> registry, IForgeRegistry<T> forgeRegistry, Class<? super T> valueClass) {
        return new ForgeRegistryWrapper<T>(registry, forgeRegistry, valueClass);
    }

    static {
        REGISTRATION_ORDER_MAP.put(RECIPE_SERIALIZERS, Lists.newArrayList((Object[])new Registry[]{RECIPE_CONDITION_SERIALIZERS}));
    }

    public static interface Registry<T> {
        public ResourceLocation getRegistryIdentifier();

        @Nullable
        public net.minecraft.core.Registry<T> getVanillaRegistry();

        public boolean hasVanillaRegistry();

        @Nullable
        public IForgeRegistry<T> getForgeRegistry();

        public boolean hasForgeRegistry();

        public void register(ResourceLocation var1, T var2);

        public ResourceLocation getIdentifier(T var1);

        public boolean hasIdentifier(ResourceLocation var1);

        public T getValue(ResourceLocation var1);

        public Set<ResourceLocation> getIdentifiers();

        public Collection<T> getValues();

        public Set<Pair<ResourceLocation, T>> getEntries();

        public Class<T> getValueClass();
    }

    private static class RecipeConditionSerializerRegistry
    implements Registry<IConditionSerializer<?>> {
        private static final Supplier<Map<ResourceLocation, IConditionSerializer<?>>> craftingHelperConditions;
        private static final ResourceLocation IDENTIFIER;
        private final Map<ResourceLocation, IConditionSerializer<?>> identifierToObject;
        private final Map<IConditionSerializer<?>, ResourceLocation> objectToIdentifier = new HashMap();
        private final Set<Pair<ResourceLocation, IConditionSerializer<?>>> entries = new HashSet();
        private final Class<IConditionSerializer<?>> valueClass = IConditionSerializer.class;

        private RecipeConditionSerializerRegistry() {
            this.identifierToObject = craftingHelperConditions.get();
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return IDENTIFIER;
        }

        @Override
        @Nullable
        public net.minecraft.core.Registry<IConditionSerializer<?>> getVanillaRegistry() {
            return null;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return false;
        }

        @Override
        @Nullable
        public IForgeRegistry<IConditionSerializer<?>> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, IConditionSerializer<?> object) {
            if (this.identifierToObject.containsKey(identifier)) {
                throw new RuntimeException("Duplicate registry for identifier '" + identifier + "'!");
            }
            if (this.objectToIdentifier.containsKey(object)) {
                throw new RuntimeException("Duplicate registry for object under '" + this.objectToIdentifier.get(object) + "' and '" + identifier + "'!");
            }
            if (!identifier.equals((Object)object.getID())) {
                throw new IllegalArgumentException("Condition serializer's id '" + object.getID() + "' does not match the given id '" + identifier + "'!");
            }
            CraftingHelper.register(object);
        }

        public void onObjectAdded(IConditionSerializer<?> object) {
            this.objectToIdentifier.put(object, object.getID());
            this.entries.add(Pair.of(object.getID(), object));
        }

        @Override
        public ResourceLocation getIdentifier(IConditionSerializer<?> object) {
            return this.objectToIdentifier.get(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.identifierToObject.containsKey(identifier);
        }

        @Override
        public IConditionSerializer<?> getValue(ResourceLocation identifier) {
            return this.identifierToObject.get(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return Collections.unmodifiableSet(this.identifierToObject.keySet());
        }

        @Override
        public Collection<IConditionSerializer<?>> getValues() {
            return Collections.unmodifiableCollection(this.objectToIdentifier.keySet());
        }

        @Override
        public Set<Pair<ResourceLocation, IConditionSerializer<?>>> getEntries() {
            return Collections.unmodifiableSet(this.entries);
        }

        @Override
        public Class<IConditionSerializer<?>> getValueClass() {
            return this.valueClass;
        }

        static {
            try {
                Field field = CraftingHelper.class.getDeclaredField("conditions");
                field.setAccessible(true);
                craftingHelperConditions = () -> {
                    try {
                        return (Map)field.get(null);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            IDENTIFIER = new ResourceLocation("supermartijn642corelib", "resource_conditions");
        }
    }

    private static class VanillaRegistryWrapper<T>
    implements Registry<T> {
        private final net.minecraft.core.Registry<T> registry;
        private final ResourceLocation identifier;
        private final Class<T> valueClass;

        private VanillaRegistryWrapper(net.minecraft.core.Registry<T> registry, Class<? super T> valueClass) {
            this.registry = registry;
            this.identifier = registry.m_123023_().m_135782_();
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Deprecated
        @Nullable
        public net.minecraft.core.Registry<T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return true;
        }

        @Override
        @Deprecated
        @Nullable
        public IForgeRegistry<T> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            net.minecraft.core.Registry.m_122965_(this.registry, (ResourceLocation)identifier, object);
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.registry.m_7981_(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.registry.m_7804_(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return (T)this.registry.m_7745_(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return this.registry.m_6566_();
        }

        @Override
        public Collection<T> getValues() {
            return MappedSetView.map(this.registry.m_6579_(), Map.Entry::getValue);
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return MappedSetView.map(this.registry.m_6579_(), entry -> Pair.of(((ResourceKey)entry.getKey()).m_135782_(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            int result = this.registry.hashCode();
            result = 31 * result + this.valueClass.hashCode();
            return result;
        }
    }

    private static class ForgeRegistryWrapper<T>
    implements Registry<T> {
        private final net.minecraft.core.Registry<T> registry;
        private final IForgeRegistry<T> forgeRegistry;
        private final ResourceLocation identifier;
        private final Class<T> valueClass;

        private ForgeRegistryWrapper(net.minecraft.core.Registry<T> registry, IForgeRegistry<T> forgeRegistry, Class<? super T> valueClass) {
            this.registry = registry;
            this.forgeRegistry = forgeRegistry;
            this.identifier = forgeRegistry.getRegistryName();
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Deprecated
        @Nullable
        public net.minecraft.core.Registry<T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return this.registry != null;
        }

        @Override
        @Deprecated
        @Nullable
        public IForgeRegistry<T> getForgeRegistry() {
            return this.forgeRegistry;
        }

        @Override
        public boolean hasForgeRegistry() {
            return true;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            this.forgeRegistry.register(identifier, object);
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.forgeRegistry.getKey(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.forgeRegistry.containsKey(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return (T)this.forgeRegistry.getValue(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return this.forgeRegistry.getKeys();
        }

        @Override
        public Collection<T> getValues() {
            return this.forgeRegistry.getValues();
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return MappedSetView.map(this.forgeRegistry.getEntries(), entry -> Pair.of(((ResourceKey)entry.getKey()).m_135782_(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            int result = this.registry.hashCode();
            result = 31 * result + this.forgeRegistry.hashCode();
            result = 31 * result + this.valueClass.hashCode();
            return result;
        }
    }
}

