/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.crafttweaker;

import com.blamejared.crafttweaker.api.natives.NativeTypeInfo;
import com.blamejared.crafttweaker.api.zencode.ZenTypeInfo;
import com.blamejared.crafttweaker_annotations.annotations.NativeConstructor;
import com.blamejared.crafttweaker_annotations.annotations.NativeMethod;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.openzen.zencode.java.ZenCodeType;

final class AnnotationsToApiConverters {
    AnnotationsToApiConverters() {
    }

    NativeTypeInfo toNativeTypeInfo(NativeTypeRegistration registration, NativeMethod ... methods) {
        return new NativeTypeInfo(registration.zenCodeName(), registration.value(), this.toNativeConstructors(registration.constructors()), this.toNativeMethods(methods));
    }

    ZenTypeInfo toZenTypeInfo(ZenCodeType.Name name) {
        return new ZenTypeInfo(name.value(), ZenTypeInfo.TypeKind.CLASS);
    }

    ZenTypeInfo toZenTypeInfo(ZenCodeType.Expansion expansion) {
        return new ZenTypeInfo(expansion.value(), ZenTypeInfo.TypeKind.EXPANSION);
    }

    private NativeTypeInfo.Constructor[] toNativeConstructors(NativeConstructor ... constructors) {
        return (NativeTypeInfo.Constructor[])Arrays.stream(constructors).map(this::toNativeConstructor).toArray(NativeTypeInfo.Constructor[]::new);
    }

    private NativeTypeInfo.Constructor toNativeConstructor(NativeConstructor constructor) {
        return new NativeTypeInfo.Constructor(constructor.description(), constructor.getSinceVersion(), constructor.deprecationMessage(), this.toNativeParameters(constructor.value()));
    }

    private NativeTypeInfo.Parameter[] toNativeParameters(NativeConstructor.ConstructorParameter ... parameters) {
        return (NativeTypeInfo.Parameter[])Arrays.stream(parameters).map(this::toNativeParameter).toArray(NativeTypeInfo.Parameter[]::new);
    }

    private NativeTypeInfo.Parameter toNativeParameter(NativeConstructor.ConstructorParameter parameter) {
        return new NativeTypeInfo.Parameter(parameter.type(), parameter.name(), parameter.description(), parameter.examples());
    }

    private NativeTypeInfo.Method[] toNativeMethods(NativeMethod ... methods) {
        return (NativeTypeInfo.Method[])Arrays.stream(methods).map(this::toNativeMethod).toArray(NativeTypeInfo.Method[]::new);
    }

    private NativeTypeInfo.Method toNativeMethod(NativeMethod method) {
        return new NativeTypeInfo.Method(method.name(), method.getterName(), method.setterName(), this.toNativeParameters(method.parameters()));
    }

    private NativeTypeInfo.Parameter[] toNativeParameters(Class<?> ... parameterTypes) {
        AtomicInteger counter = new AtomicInteger(0);
        return (NativeTypeInfo.Parameter[])Arrays.stream(parameterTypes).map(it -> this.toNativeParameter((Class<?>)it, counter.getAndIncrement())).toArray(NativeTypeInfo.Parameter[]::new);
    }

    private NativeTypeInfo.Parameter toNativeParameter(Class<?> parameterType, int counter) {
        return new NativeTypeInfo.Parameter(parameterType, "$$" + counter);
    }
}

