/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class PlayerActivityTracker {
    private static final Set<UUID> activePlayers = new LinkedHashSet<UUID>();
    private static final Set<UUID> onlinePlayers = new LinkedHashSet<UUID>();
    private static final Map<UUID, ActiveTime> lastActiveTimePerPlayer = new HashMap<UUID, ActiveTime>();
    private static final SortedSet<ActiveTime> sortedActiveTimes = new TreeSet<ActiveTime>();
    private static boolean dirty = false;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        ActiveTime lastActiveTime;
        UUID playerId = e.getEntity().m_20148_();
        onlinePlayers.add(playerId);
        if (!activePlayers.contains(playerId)) {
            activePlayers.add(playerId);
            if (PlayerActivityTracker.isInactivityTimeOutEnabled()) {
                e.getEntity().m_20194_().m_129785_().forEach(level -> ChunkLoadingCapability.get((Level)level).castServer().togglePlayerActivity(playerId, true));
            }
        }
        if ((lastActiveTime = lastActiveTimePerPlayer.remove(playerId)) != null) {
            sortedActiveTimes.remove(lastActiveTime);
        }
        dirty = true;
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent e) {
        UUID playerId = e.getEntity().m_20148_();
        onlinePlayers.remove(playerId);
        ActiveTime lastActiveTime = new ActiveTime(playerId, System.currentTimeMillis());
        lastActiveTimePerPlayer.put(playerId, lastActiveTime);
        sortedActiveTimes.add(lastActiveTime);
        dirty = true;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            return;
        }
        long timeoutTime = System.currentTimeMillis() - PlayerActivityTracker.getInactivityTimeout();
        while (!sortedActiveTimes.isEmpty()) {
            ActiveTime earliestExpiringTime = sortedActiveTimes.first();
            if (earliestExpiringTime.lastActiveTime >= timeoutTime) break;
            sortedActiveTimes.remove(earliestExpiringTime);
            lastActiveTimePerPlayer.remove(earliestExpiringTime.player);
            activePlayers.remove(earliestExpiringTime.player);
            dirty = true;
            ActiveTime finalEarliestExpiringTime = earliestExpiringTime;
            if (!PlayerActivityTracker.isInactivityTimeOutEnabled()) continue;
            ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(level -> ChunkLoadingCapability.get((Level)level).castServer().togglePlayerActivity(finalEarliestExpiringTime.player, false));
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerAboutToStartEvent e) {
        activePlayers.clear();
        onlinePlayers.clear();
        lastActiveTimePerPlayer.clear();
        sortedActiveTimes.clear();
        dirty = false;
        File file = new File(e.getServer().m_129843_(LevelResource.f_78182_).toFile(), "chunkloaders/active_players.nbt");
        if (!file.exists()) {
            return;
        }
        try {
            CompoundTag data = NbtIo.m_128953_((File)file);
            if (data != null) {
                PlayerActivityTracker.read(data);
            }
        }
        catch (IOException exception) {
            ChunkLoaders.LOGGER.error("Failed to load player activity data!", (Throwable)exception);
        }
    }

    @SubscribeEvent
    public static void onWorldSave(LevelEvent.Save e) {
        if (!(e.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (dirty) {
            CompoundTag data = PlayerActivityTracker.write();
            File file = new File(((ServerLevel)e.getLevel()).m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "chunkloaders/active_players.nbt");
            file.getParentFile().mkdirs();
            try {
                NbtIo.m_128955_((CompoundTag)data, (File)file);
            }
            catch (IOException exception) {
                ChunkLoaders.LOGGER.error("Failed to write active player data!", (Throwable)exception);
                return;
            }
            dirty = false;
        }
    }

    public static boolean isPlayerActive(UUID player) {
        return !PlayerActivityTracker.isInactivityTimeOutEnabled() || activePlayers.contains(player);
    }

    private static boolean isInactivityTimeOutEnabled() {
        return ChunkLoadersConfig.inactivityTimeout.get() > 0L;
    }

    private static long getInactivityTimeout() {
        return ChunkLoadersConfig.inactivityTimeout.get() * 60L * 1000L;
    }

    private static CompoundTag write() {
        CompoundTag tag;
        ListTag activeTimes = new ListTag();
        for (UUID player : onlinePlayers) {
            tag = new CompoundTag();
            tag.m_128362_("player", player);
            tag.m_128356_("time", System.currentTimeMillis());
            activeTimes.add((Object)tag);
        }
        for (ActiveTime activeTime : lastActiveTimePerPlayer.values()) {
            tag = new CompoundTag();
            tag.m_128362_("player", activeTime.player);
            tag.m_128356_("time", activeTime.lastActiveTime);
            activeTimes.add((Object)tag);
        }
        CompoundTag tag2 = new CompoundTag();
        tag2.m_128365_("times", (Tag)activeTimes);
        return tag2;
    }

    private static void read(CompoundTag tag) {
        ListTag activeTimes = tag.m_128437_("times", 10);
        for (Tag nbt : activeTimes) {
            CompoundTag timeTag;
            if (!(nbt instanceof CompoundTag) || !(timeTag = (CompoundTag)nbt).m_128425_("player", 11) || !timeTag.m_128425_("time", 4)) continue;
            ActiveTime activeTime = new ActiveTime(timeTag.m_128342_("player"), timeTag.m_128454_("time"));
            activePlayers.add(activeTime.player);
            sortedActiveTimes.add(activeTime);
        }
    }

    private static class ActiveTime
    implements Comparable<ActiveTime> {
        public final UUID player;
        public long lastActiveTime;

        public ActiveTime(UUID player, long lastActiveTime) {
            this.player = player;
            this.lastActiveTime = lastActiveTime;
        }

        @Override
        public int compareTo(ActiveTime other) {
            return Long.compare(this.lastActiveTime, other.lastActiveTime);
        }
    }
}

