/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.lootbeams.Configuration;
import com.lootbeams.LootBeamRenderer;
import com.lootbeams.LootBeams;
import com.lootbeams.compat.ApotheosisCompat;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="lootbeams", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientSetup {
    public static final List<Consumer<PoseStack>> delayedRenders = new ArrayList<Consumer<PoseStack>>();

    public static void init(FMLClientSetupEvent ignored) {
        ignored.enqueueWork(() -> {
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::onRenderNameplate);
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::onItemCreation);
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::entityRemoval);
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::onLevelRender);
        });
    }

    @SubscribeEvent
    public static void onHudRender(RenderGuiOverlayEvent.Post event) {
        Entity entity;
        LocalPlayer player;
        HitResult result;
        if (event.getOverlay().equals((Object)VanillaGuiOverlay.CROSSHAIR.type()) && ((Boolean)Configuration.ADVANCED_TOOLTIPS.get()).booleanValue() && (Minecraft.m_91087_().f_91080_ == null || Minecraft.m_91087_().f_91080_ instanceof ChatScreen) && (result = ClientSetup.getEntityItem((Player)(player = Minecraft.m_91087_().f_91074_))) != null && result.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)result).m_82443_()) instanceof ItemEntity) {
            int x;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (((Boolean)Configuration.REQUIRE_ON_GROUND.get()).booleanValue() && !itemEntity.m_20096_()) {
                return;
            }
            int rarityX = x = event.getWindow().m_85445_() / 2;
            int y = event.getWindow().m_85446_() / 2;
            List<MutableComponent> tooltipLines = Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)itemEntity.m_32055_());
            if (((Boolean)Configuration.WORLDSPACE_TOOLTIPS.get()).booleanValue()) {
                Vec3 tooltipWorldPos = itemEntity.m_20182_().m_82520_(0.0, Math.min(1.0, Minecraft.m_91087_().f_91074_.m_20280_((Entity)itemEntity) * 0.025) + (Double)Configuration.NAMETAG_Y_OFFSET.get() + (double)((float)Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)itemEntity.m_32055_()).size() / 100.0f), 0.0);
                Vector3f desiredScreenSpacePos = ClientSetup.worldToScreenSpace(tooltipWorldPos, event.getPartialTick());
                float f = Mth.m_14036_((float)desiredScreenSpacePos.x(), (float)0.0f, (float)event.getWindow().m_85445_());
                float f2 = desiredScreenSpacePos.y();
                int n = event.getWindow().m_85446_();
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                desiredScreenSpacePos = new Vector3f(f, Mth.m_14036_((float)f2, (float)0.0f, (float)(n - 9 * Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)itemEntity.m_32055_()).size())), desiredScreenSpacePos.z());
                Component longestLine = tooltipLines.stream().max((a, b) -> Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)a) - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)b)).orElse((Component)Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)itemEntity.m_32055_()).get(0));
                if (((Boolean)Configuration.SCREEN_TOOLTIPS_REQUIRE_CROUCH.get()).booleanValue() && !player.m_6047_()) {
                    longestLine = (Component)tooltipLines.get(0);
                }
                x = (int)desiredScreenSpacePos.x() - 10 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)longestLine) / 2;
                rarityX = (int)desiredScreenSpacePos.x() - 12 - Minecraft.m_91087_().f_91062_.m_92895_(LootBeamRenderer.capitalize(itemEntity.m_32055_().m_41791_().name().toLowerCase())) / 2;
                y = (int)desiredScreenSpacePos.y();
            }
            int guiScale = (Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_();
            if (tooltipLines.size() > 6) {
                Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)1);
            }
            if (((Boolean)Configuration.SCREEN_TOOLTIPS_REQUIRE_CROUCH.get()).booleanValue() && player.m_6047_() || !((Boolean)Configuration.SCREEN_TOOLTIPS_REQUIRE_CROUCH.get()).booleanValue()) {
                event.getGuiGraphics().m_280153_(Minecraft.m_91087_().f_91062_, itemEntity.m_32055_(), x, y);
            } else {
                tooltipLines = List.of((Component)tooltipLines.get(0), Component.m_237113_((String)LootBeamRenderer.capitalize(itemEntity.m_32055_().m_41791_().name().toLowerCase())).m_130948_(itemEntity.m_32055_().m_41611_().m_7383_()));
                if (ModList.get().isLoaded("apotheosis") && ApotheosisCompat.isApotheosisItem(itemEntity.m_32055_())) {
                    tooltipLines = List.of((Component)tooltipLines.get(0), Component.m_237113_((String)LootBeamRenderer.capitalize(ApotheosisCompat.getRarityName(itemEntity.m_32055_()))).m_130938_(s -> s.m_131148_(ApotheosisCompat.getRarityColor(itemEntity.m_32055_()))));
                }
                if (((Boolean)Configuration.COMBINE_NAME_AND_RARITY.get()).booleanValue()) {
                    event.getGuiGraphics().renderTooltip(Minecraft.m_91087_().f_91062_, tooltipLines, itemEntity.m_32055_().m_150921_(), itemEntity.m_32055_(), x, y);
                } else {
                    event.getGuiGraphics().renderTooltip(Minecraft.m_91087_().f_91062_, List.of((Component)tooltipLines.get(0)), itemEntity.m_32055_().m_150921_(), itemEntity.m_32055_(), x, y);
                    GuiGraphics guiGraphics = event.getGuiGraphics();
                    Font font = Minecraft.m_91087_().f_91062_;
                    List<Component> list = List.of((Component)tooltipLines.get(1));
                    Optional optional = itemEntity.m_32055_().m_150921_();
                    ItemStack itemStack = itemEntity.m_32055_();
                    Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                    guiGraphics.renderTooltip(font, list, optional, itemStack, rarityX, y + 9 * 2);
                }
            }
            Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)guiScale);
        }
    }

    public static Vector3f worldToScreenSpace(Vec3 pos, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPosition = camera.m_90583_();
        Vector3f position = new Vector3f((float)(cameraPosition.f_82479_ - pos.f_82479_), (float)(cameraPosition.f_82480_ - pos.f_82480_), (float)(cameraPosition.f_82481_ - pos.f_82481_));
        Quaternionf cameraRotation = camera.m_253121_();
        cameraRotation.conjugate();
        cameraRotation.transform(position);
        if (((Boolean)mc.f_91066_.f_92080_.m_231551_()).booleanValue() && mc.m_91288_() instanceof Player) {
            Player player = (Player)mc.m_91288_();
            float playerStep = player.f_19787_ - player.f_19867_;
            float stepSize = -(player.f_19787_ + playerStep * partialTicks);
            float viewBob = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
            Quaternionf bobXRotation = Axis.f_252529_.m_252977_(Math.abs(Mth.m_14089_((float)(stepSize * (float)Math.PI - 0.2f)) * viewBob) * 5.0f);
            Quaternionf bobZRotation = Axis.f_252403_.m_252977_(Mth.m_14031_((float)(stepSize * (float)Math.PI)) * viewBob * 3.0f);
            bobXRotation.conjugate();
            bobZRotation.conjugate();
            bobXRotation.transform(position);
            bobZRotation.transform(position);
            position.add(Mth.m_14031_((float)(stepSize * (float)Math.PI)) * viewBob * 0.5f, Math.abs(Mth.m_14089_((float)(stepSize * (float)Math.PI)) * viewBob), 0.0f);
        }
        Window window = mc.m_91268_();
        float screenSize = (float)window.m_85446_() / 2.0f / position.z() / (float)Math.tan(Math.toRadians(mc.f_91063_.m_109141_(camera, partialTicks, true) / 2.0));
        position.mul(-screenSize, -screenSize, 1.0f);
        position.add((float)window.m_85445_() / 2.0f, (float)window.m_85446_() / 2.0f, 0.0f);
        return position;
    }

    public static HitResult getEntityItem(Player player) {
        Minecraft mc = Minecraft.m_91087_();
        double distance = player.getBlockReach();
        float partialTicks = mc.m_91297_();
        Vec3 position = player.m_20299_(partialTicks);
        Vec3 view = player.m_20252_(partialTicks);
        if (mc.f_91077_ != null && mc.f_91077_.m_6662_() != HitResult.Type.MISS) {
            distance = mc.f_91077_.m_82450_().m_82554_(position);
        }
        return ClientSetup.getEntityItem(player, position, position.m_82520_(view.f_82479_ * distance, view.f_82480_ * distance, view.f_82481_ * distance));
    }

    public static HitResult getEntityItem(Player player, Vec3 position, Vec3 look) {
        Vec3 include = look.m_82546_(position);
        List list = player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82363_(include.f_82479_, include.f_82480_, include.f_82481_));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof ItemEntity)) continue;
            AABB axisalignedbb = entity.m_20191_().m_82400_(0.5).m_82377_(0.0, 0.5, 0.0);
            Optional vec = axisalignedbb.m_82371_(position, look);
            if (vec.isPresent()) {
                return new EntityHitResult(entity, (Vec3)vec.get());
            }
            if (!axisalignedbb.m_82390_(position)) continue;
            return new EntityHitResult(entity);
        }
        return null;
    }

    public static void onItemCreation(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)entity;
            LootBeamRenderer.TOOLTIP_CACHE.computeIfAbsent(ie, itemEntity -> itemEntity.m_32055_().m_41651_(null, (TooltipFlag)TooltipFlag.Default.f_256752_));
            if (!LootBeamRenderer.LIGHT_CACHE.contains(ie)) {
                LootBeamRenderer.LIGHT_CACHE.add(ie);
            }
        }
    }

    public static void onLevelRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            PoseStack stack = event.getPoseStack();
            stack.m_85836_();
            Vec3 pos = event.getCamera().m_90583_();
            stack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
            delayedRenders.forEach(consumer -> consumer.accept(stack));
            stack.m_85849_();
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            delayedRenders.clear();
        }
    }

    public static void entityRemoval(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)entity;
            LootBeamRenderer.TOOLTIP_CACHE.remove(ie);
            LootBeamRenderer.LIGHT_CACHE.remove(ie);
        }
    }

    public static int overrideLight(ItemEntity ie, int light) {
        if ((Boolean)Configuration.ALL_ITEMS.get() != false || (Boolean)Configuration.ONLY_EQUIPMENT.get() != false && ClientSetup.isEquipmentItem(ie.m_32055_().m_41720_()) || (Boolean)Configuration.ONLY_RARE.get() != false && LootBeamRenderer.compatRarityCheck(ie, false) || ClientSetup.isItemInRegistryList((List)Configuration.WHITELIST.get(), ie.m_32055_().m_41720_())) {
            light = 0xF00000;
        }
        return light;
    }

    public static void playDropSound(ItemEntity itemEntity) {
        WeighedSoundEvents sound;
        if (!((Boolean)Configuration.SOUND.get()).booleanValue()) {
            return;
        }
        Item item = itemEntity.m_32055_().m_41720_();
        if (((Boolean)Configuration.SOUND_ALL_ITEMS.get() != false && !ClientSetup.isItemInRegistryList((List)Configuration.BLACKLIST.get(), item) || (Boolean)Configuration.SOUND_ONLY_EQUIPMENT.get() != false && ClientSetup.isEquipmentItem(item) || (Boolean)Configuration.SOUND_ONLY_RARE.get() != false && LootBeamRenderer.compatRarityCheck(itemEntity, false) || ClientSetup.isItemInRegistryList((List)Configuration.SOUND_ONLY_WHITELIST.get(), item)) && (sound = Minecraft.m_91087_().m_91106_().m_120384_(LootBeams.LOOT_DROP)) != null && Minecraft.m_91087_().f_91073_ != null) {
            Minecraft.m_91087_().f_91073_.m_6263_((Player)Minecraft.m_91087_().f_91074_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), SoundEvent.m_262824_((ResourceLocation)LootBeams.LOOT_DROP), SoundSource.AMBIENT, 0.1f * ((Double)Configuration.SOUND_VOLUME.get()).floatValue(), 1.0f);
        }
    }

    public static void onRenderNameplate(RenderNameTagEvent event) {
        boolean shouldRender;
        ItemEntity itemEntity;
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity) || Minecraft.m_91087_().f_91074_.m_20280_((Entity)(itemEntity = (ItemEntity)entity)) > Math.pow((Double)Configuration.RENDER_DISTANCE.get(), 2.0)) {
            return;
        }
        Item item = itemEntity.m_32055_().m_41720_();
        boolean bl = shouldRender = ((Boolean)Configuration.ALL_ITEMS.get() != false || (Boolean)Configuration.ONLY_EQUIPMENT.get() != false && ClientSetup.isEquipmentItem(item) || (Boolean)Configuration.ONLY_RARE.get() != false && LootBeamRenderer.compatRarityCheck(itemEntity, false) || ClientSetup.isItemInRegistryList((List)Configuration.WHITELIST.get(), itemEntity.m_32055_().m_41720_())) && !ClientSetup.isItemInRegistryList((List)Configuration.BLACKLIST.get(), itemEntity.m_32055_().m_41720_());
        if (shouldRender && (!((Boolean)Configuration.REQUIRE_ON_GROUND.get()).booleanValue() || itemEntity.m_20096_())) {
            delayedRenders.add(stack -> {
                stack.m_85836_();
                stack.m_85837_(itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_());
                LootBeamRenderer.renderLootBeam(stack, event.getMultiBufferSource(), event.getPartialTick(), itemEntity.m_9236_().m_46467_(), itemEntity);
                stack.m_85849_();
            });
        }
    }

    public static boolean isEquipmentItem(Item item) {
        return item instanceof TieredItem || item instanceof ArmorItem || item instanceof ShieldItem || item instanceof BowItem || item instanceof CrossbowItem;
    }

    private static boolean isItemInRegistryList(List<String> registryNames, Item item) {
        if (registryNames.isEmpty()) {
            return false;
        }
        for (String id : registryNames.stream().filter(s -> !s.isEmpty()).toList()) {
            if (!id.contains(":") && ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().equals(id)) {
                return true;
            }
            ResourceLocation itemResource = ResourceLocation.m_135820_((String)id);
            if (itemResource == null || ((Item)ForgeRegistries.ITEMS.getValue(itemResource)).m_5456_() != item.m_5456_()) continue;
            return true;
        }
        return false;
    }
}

