/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import com.github.nyuppo.config.VariantWeights;
import com.github.nyuppo.mixin.MobVariantsMixin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class})
public abstract class ZombieVariantsMixin
extends MobVariantsMixin {
    private static final EntityDataAccessor<String> VARIANT_ID = SynchedEntityData.m_135353_(Zombie.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final String NBT_KEY = "Variant";

    @Override
    protected void onDefineSynchedData(CallbackInfo ci) {
        ((Zombie)this).m_20088_().m_135372_(VARIANT_ID, (Object)"default");
    }

    @Override
    protected void onAddAdditionalSaveData(CompoundTag p_21484_, CallbackInfo ci) {
        p_21484_.m_128359_(NBT_KEY, (String)((Zombie)this).m_20088_().m_135370_(VARIANT_ID));
    }

    @Override
    protected void onReadAdditionalSaveData(CompoundTag p_21450_, CallbackInfo ci) {
        ((Zombie)this).m_20088_().m_135381_(VARIANT_ID, (Object)p_21450_.m_128461_(NBT_KEY));
    }

    @Override
    protected void onFinalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_, CallbackInfoReturnable<SpawnGroupData> cir) {
        String variant = this.getRandomVariant(p_21434_.m_213780_());
        ((Zombie)this).m_20088_().m_135381_(VARIANT_ID, (Object)variant);
    }

    @Override
    protected void onTick(CallbackInfo ci) {
        if (((String)((Zombie)this).m_20088_().m_135370_(VARIANT_ID)).isEmpty()) {
            String variant = this.getRandomVariant(((Zombie)this).m_9236_().m_213780_());
            ((Zombie)this).m_20088_().m_135381_(VARIANT_ID, (Object)variant);
        }
    }

    private String getRandomVariant(RandomSource random) {
        return VariantWeights.getRandomVariant("zombie", random);
    }
}

