/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Wolf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WolfRenderer.class})
public class WolfRendererMixin {
    private static final ResourceLocation DEFAULT_WILD = new ResourceLocation("textures/entity/wolf/wolf.png");
    private static final ResourceLocation DEFAULT_TAMED = new ResourceLocation("textures/entity/wolf/wolf_tame.png");
    private static final ResourceLocation DEFAULT_ANGRY = new ResourceLocation("textures/entity/wolf/wolf_angry.png");

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Wolf;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetTextureLocation(Wolf p_116526_, CallbackInfoReturnable<ResourceLocation> ci) {
        CompoundTag nbt = new CompoundTag();
        p_116526_.m_20240_(nbt);
        if (nbt.m_128441_("Variant")) {
            String variant = nbt.m_128461_("Variant");
            if (variant.equals("default")) {
                if (p_116526_.m_21824_()) {
                    ci.setReturnValue((Object)DEFAULT_TAMED);
                } else {
                    ci.setReturnValue((Object)(p_116526_.m_21660_() ? DEFAULT_ANGRY : DEFAULT_WILD));
                }
            } else if (p_116526_.m_21824_()) {
                ci.setReturnValue((Object)new ResourceLocation("moremobvariants", "textures/entity/wolf/" + variant + "_tame.png"));
            } else {
                ci.setReturnValue((Object)(p_116526_.m_21660_() ? new ResourceLocation("moremobvariants", "textures/entity/wolf/" + variant + "_angry.png") : new ResourceLocation("moremobvariants", "textures/entity/wolf/" + variant + "_wild.png")));
            }
        }
    }
}

