/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import com.github.nyuppo.config.VariantWeights;
import com.github.nyuppo.mixin.MobVariantsMixin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sheep.class})
public abstract class SheepVariantsMixin
extends MobVariantsMixin {
    private static final EntityDataAccessor<String> VARIANT_ID = SynchedEntityData.m_135353_(Sheep.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final String NBT_KEY = "Variant";

    @Override
    protected void onDefineSynchedData(CallbackInfo ci) {
        ((Sheep)this).m_20088_().m_135372_(VARIANT_ID, (Object)"default");
    }

    @Override
    protected void onAddAdditionalSaveData(CompoundTag p_21484_, CallbackInfo ci) {
        p_21484_.m_128359_(NBT_KEY, (String)((Sheep)this).m_20088_().m_135370_(VARIANT_ID));
    }

    @Override
    protected void onReadAdditionalSaveData(CompoundTag p_21450_, CallbackInfo ci) {
        ((Sheep)this).m_20088_().m_135381_(VARIANT_ID, (Object)p_21450_.m_128461_(NBT_KEY));
    }

    @Override
    protected void onFinalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_, CallbackInfoReturnable<SpawnGroupData> cir) {
        String variant = this.getRandomVariant(p_21434_.m_213780_());
        ((Sheep)this).m_20088_().m_135381_(VARIANT_ID, (Object)variant);
    }

    @Override
    protected void onTick(CallbackInfo ci) {
        if (((String)((Sheep)this).m_20088_().m_135370_(VARIANT_ID)).isEmpty()) {
            String variant = this.getRandomVariant(((Sheep)this).m_9236_().m_213780_());
            ((Sheep)this).m_20088_().m_135381_(VARIANT_ID, (Object)variant);
        }
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Sheep;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBreedOffspring(ServerLevel p_148890_, AgeableMob p_148891_, CallbackInfoReturnable<Sheep> ci) {
        Sheep child = (Sheep)EntityType.f_20520_.m_20615_((Level)p_148890_);
        String variant = "default";
        if (p_148891_.m_217043_().m_188503_(4) != 0) {
            CompoundTag thisNbt = new CompoundTag();
            ((Sheep)this).m_20240_(thisNbt);
            CompoundTag parentNbt = new CompoundTag();
            p_148891_.m_20240_(parentNbt);
            if (thisNbt.m_128441_(NBT_KEY) && parentNbt.m_128441_(NBT_KEY)) {
                String parentVariant;
                String thisVariant = thisNbt.m_128461_(NBT_KEY);
                variant = thisVariant.equals(parentVariant = parentNbt.m_128461_(NBT_KEY)) ? thisVariant : (p_148891_.m_217043_().m_188499_() ? thisVariant : parentVariant);
            }
        } else {
            variant = this.getRandomVariant(p_148891_.m_217043_());
        }
        CompoundTag childNbt = new CompoundTag();
        child.m_20240_(childNbt);
        childNbt.m_128359_(NBT_KEY, variant);
        child.m_7378_(childNbt);
        ci.setReturnValue((Object)child);
    }

    private String getRandomVariant(RandomSource random) {
        return VariantWeights.getRandomVariant("sheep", random);
    }
}

