/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.config;

import com.github.nyuppo.config.VariantBlacklist;
import com.github.nyuppo.util.WeightedRandomBag;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.util.RandomSource;

public class VariantWeights {
    private static HashMap<String, Integer> chickenWeights = new HashMap();
    private static HashMap<String, Integer> cowWeights = new HashMap();
    private static HashMap<String, Integer> pigWeights = new HashMap();
    private static HashMap<String, Integer> sheepWeights = new HashMap();
    private static HashMap<String, Integer> wolfWeights = new HashMap();
    private static HashMap<String, Integer> zombieWeights = new HashMap();
    private static final HashMap<String, Integer> defaultChickenWeights = new HashMap();
    private static final HashMap<String, Integer> defaultCowWeights;
    private static final HashMap<String, Integer> defaultPigWeights;
    private static final HashMap<String, Integer> defaultSheepWeights;
    private static final HashMap<String, Integer> defaultWolfWeights;
    private static final HashMap<String, Integer> defaultZombieWeights;

    public static void setChickenWeights(HashMap<String, Integer> weights) {
        chickenWeights = weights;
    }

    public static HashMap<String, Integer> getChickenWeights() {
        return chickenWeights;
    }

    public static void setCowWeights(HashMap<String, Integer> weights) {
        cowWeights = weights;
    }

    public static HashMap<String, Integer> getCowWeights() {
        return cowWeights;
    }

    public static void setPigWeights(HashMap<String, Integer> weights) {
        pigWeights = weights;
    }

    public static HashMap<String, Integer> getPigWeights() {
        return pigWeights;
    }

    public static void setSheepWeights(HashMap<String, Integer> weights) {
        sheepWeights = weights;
    }

    public static HashMap<String, Integer> getSheepWeights() {
        return sheepWeights;
    }

    public static void setWolfWeights(HashMap<String, Integer> weights) {
        wolfWeights = weights;
    }

    public static HashMap<String, Integer> getWolfWeights() {
        return wolfWeights;
    }

    public static void setZombieWeights(HashMap<String, Integer> weights) {
        zombieWeights = weights;
    }

    public static HashMap<String, Integer> getZombieWeights() {
        return zombieWeights;
    }

    public static void resetChickenWeights() {
        chickenWeights = defaultChickenWeights;
    }

    public static void resetCowWeights() {
        cowWeights = defaultCowWeights;
    }

    public static void resetPigWeights() {
        pigWeights = defaultPigWeights;
    }

    public static void resetSheepWeights() {
        sheepWeights = defaultSheepWeights;
    }

    public static void resetWolfWeights() {
        wolfWeights = defaultWolfWeights;
    }

    public static void resetZombieWeights() {
        zombieWeights = defaultZombieWeights;
    }

    public static void setWeight(String mob, HashMap<String, Integer> weights) {
        switch (mob) {
            case "chicken": {
                VariantWeights.setChickenWeights(weights);
                break;
            }
            case "cow": {
                VariantWeights.setCowWeights(weights);
                break;
            }
            case "pig": {
                VariantWeights.setPigWeights(weights);
                break;
            }
            case "sheep": {
                VariantWeights.setSheepWeights(weights);
                break;
            }
            case "wolf": {
                VariantWeights.setWolfWeights(weights);
                break;
            }
            case "zombie": {
                VariantWeights.setZombieWeights(weights);
            }
        }
    }

    public static void resetWeight(String mob) {
        switch (mob) {
            case "chicken": {
                VariantWeights.resetChickenWeights();
                break;
            }
            case "cow": {
                VariantWeights.resetCowWeights();
                break;
            }
            case "pig": {
                VariantWeights.resetPigWeights();
                break;
            }
            case "sheep": {
                VariantWeights.resetSheepWeights();
                break;
            }
            case "wolf": {
                VariantWeights.resetWolfWeights();
                break;
            }
            case "zombie": {
                VariantWeights.resetZombieWeights();
            }
        }
    }

    public static String getRandomVariant(String mob, RandomSource random) {
        HashMap weights;
        switch (mob) {
            case "chicken": {
                HashMap hashMap = VariantWeights.getChickenWeights();
                break;
            }
            case "cow": {
                HashMap hashMap = VariantWeights.getCowWeights();
                break;
            }
            case "pig": {
                HashMap hashMap = VariantWeights.getPigWeights();
                break;
            }
            case "sheep": {
                HashMap hashMap = VariantWeights.getSheepWeights();
                break;
            }
            case "wolf": {
                HashMap hashMap = VariantWeights.getWolfWeights();
                break;
            }
            case "zombie": {
                HashMap hashMap = VariantWeights.getZombieWeights();
                break;
            }
            default: {
                HashMap hashMap = weights = new HashMap();
            }
        }
        if (weights.isEmpty()) {
            return "default";
        }
        WeightedRandomBag bag = new WeightedRandomBag(random, weights);
        return (String)bag.getRandom();
    }

    public static void resetWeights() {
        VariantWeights.resetChickenWeights();
        VariantWeights.resetCowWeights();
        VariantWeights.resetPigWeights();
        VariantWeights.resetSheepWeights();
        VariantWeights.resetWolfWeights();
        VariantWeights.resetZombieWeights();
    }

    public static void clearWeights() {
        chickenWeights = new HashMap();
        cowWeights = new HashMap();
        pigWeights = new HashMap();
        sheepWeights = new HashMap();
        wolfWeights = new HashMap();
        zombieWeights = new HashMap();
    }

    public static void applyBlacklists() {
        String variant;
        Iterator<String> i = chickenWeights.keySet().iterator();
        while (i.hasNext()) {
            variant = i.next();
            if (!VariantBlacklist.isBlacklisted("chicken", variant)) continue;
            i.remove();
        }
        i = cowWeights.keySet().iterator();
        while (i.hasNext()) {
            variant = i.next();
            if (!VariantBlacklist.isBlacklisted("cow", variant)) continue;
            i.remove();
        }
        i = pigWeights.keySet().iterator();
        while (i.hasNext()) {
            variant = i.next();
            if (!VariantBlacklist.isBlacklisted("pig", variant)) continue;
            i.remove();
        }
        i = sheepWeights.keySet().iterator();
        while (i.hasNext()) {
            variant = i.next();
            if (!VariantBlacklist.isBlacklisted("sheep", variant)) continue;
            i.remove();
        }
        i = wolfWeights.keySet().iterator();
        while (i.hasNext()) {
            variant = i.next();
            if (!VariantBlacklist.isBlacklisted("wolf", variant)) continue;
            i.remove();
        }
        i = zombieWeights.keySet().iterator();
        while (i.hasNext()) {
            variant = i.next();
            if (!VariantBlacklist.isBlacklisted("zombie", variant)) continue;
            i.remove();
        }
    }

    static {
        defaultChickenWeights.put("midnight", 1);
        defaultChickenWeights.put("amber", 2);
        defaultChickenWeights.put("gold_crested", 2);
        defaultChickenWeights.put("bronzed", 2);
        defaultChickenWeights.put("skewbald", 2);
        defaultChickenWeights.put("stormy", 2);
        defaultChickenWeights.put("default", 3);
        defaultCowWeights = new HashMap();
        defaultCowWeights.put("umbra", 1);
        defaultCowWeights.put("ashen", 2);
        defaultCowWeights.put("cookie", 2);
        defaultCowWeights.put("dairy", 2);
        defaultCowWeights.put("pinto", 2);
        defaultCowWeights.put("sunset", 2);
        defaultCowWeights.put("wooly", 2);
        defaultCowWeights.put("default", 3);
        defaultPigWeights = new HashMap();
        defaultPigWeights.put("mottled", 1);
        defaultPigWeights.put("piebald", 1);
        defaultPigWeights.put("pink_footed", 1);
        defaultPigWeights.put("sooty", 1);
        defaultPigWeights.put("spotted", 1);
        defaultPigWeights.put("default", 2);
        defaultSheepWeights = new HashMap();
        defaultSheepWeights.put("patched", 1);
        defaultSheepWeights.put("fuzzy", 1);
        defaultSheepWeights.put("rocky", 1);
        defaultSheepWeights.put("default", 2);
        defaultWolfWeights = new HashMap();
        defaultWolfWeights.put("jupiter", 1);
        defaultWolfWeights.put("husky", 1);
        defaultWolfWeights.put("default", 1);
        defaultZombieWeights = new HashMap();
        defaultZombieWeights.put("alex", 2);
        defaultZombieWeights.put("ari", 1);
        defaultZombieWeights.put("efe", 1);
        defaultZombieWeights.put("kai", 1);
        defaultZombieWeights.put("makena", 1);
        defaultZombieWeights.put("noor", 1);
        defaultZombieWeights.put("sunny", 1);
        defaultZombieWeights.put("zuri", 1);
        defaultZombieWeights.put("default", 3);
    }
}

