/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo;

import com.github.nyuppo.config.VariantBlacklist;
import com.github.nyuppo.config.VariantSettings;
import com.github.nyuppo.config.VariantWeights;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="moremobvariants")
public class MoreMobVariants {
    public static final String MOD_ID = "moremobvariants";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final DeferredRegister<CatVariant> CAT_VARIANTS = DeferredRegister.create((ResourceKey)Registries.f_257006_, (String)"moremobvariants");
    public static final RegistryObject<CatVariant> GRAY_TABBY = CAT_VARIANTS.register("gray_tabby", () -> new CatVariant(new ResourceLocation(MOD_ID, "textures/entity/cat/gray_tabby.png")));
    public static final RegistryObject<CatVariant> DOUG = CAT_VARIANTS.register("doug", () -> new CatVariant(new ResourceLocation(MOD_ID, "textures/entity/cat/doug.png")));
    public static final RegistryObject<CatVariant> HANDSOME = CAT_VARIANTS.register("handsome", () -> new CatVariant(new ResourceLocation(MOD_ID, "textures/entity/cat/handsome.png")));
    public static final RegistryObject<CatVariant> TORTOISESHELL = CAT_VARIANTS.register("tortoiseshell", () -> new CatVariant(new ResourceLocation(MOD_ID, "textures/entity/cat/tortoiseshell.png")));
    public static final TagKey<Block> PIG_MUD_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation("moremobvariants", "pig_mud_blocks"));

    public MoreMobVariants() {
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onReload);
        CAT_VARIANTS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Giving mobs a fresh coat of paint...");
    }

    @SubscribeEvent
    public void onReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimpleJsonResourceReloadListener(new Gson(), MOD_ID){
            private final ResourceLocation SETTINGS_ID;
            {
                this.SETTINGS_ID = new ResourceLocation(MoreMobVariants.MOD_ID, "settings/settings.json");
            }

            protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profilerFiller) {
                InputStream stream;
                String target;
                LOGGER.info("Reloading config...");
                VariantWeights.clearWeights();
                VariantBlacklist.resetBlacklists();
                for (ResourceLocation id : manager.m_214159_("weights", path -> path.m_135815_().endsWith(".json")).keySet()) {
                    target = id.m_135815_().substring(8, id.m_135815_().length() - 5);
                    try {
                        stream = ((Resource)manager.m_213713_(id).get()).m_215507_();
                        try {
                            this.applyWeight(id, new InputStreamReader(stream, StandardCharsets.UTF_8));
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occured while loading weight config " + id.m_214299_(), (Throwable)e);
                        VariantWeights.resetWeight(target);
                    }
                }
                for (ResourceLocation id : manager.m_214159_("blacklist", path -> path.m_135815_().endsWith(".json")).keySet()) {
                    target = id.m_135815_().substring(10, id.m_135815_().length() - 5);
                    try {
                        stream = ((Resource)manager.m_213713_(id).get()).m_215507_();
                        try {
                            this.applyBlacklist(id, new InputStreamReader(stream, StandardCharsets.UTF_8));
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occured while loading blacklist config " + id.m_214299_(), (Throwable)e);
                        VariantBlacklist.resetBlacklist(target);
                    }
                }
                Optional settings = manager.m_213713_(this.SETTINGS_ID);
                if (settings.isPresent()) {
                    try (InputStream stream2 = ((Resource)manager.m_213713_(this.SETTINGS_ID).get()).m_215507_();){
                        this.applySettings(new InputStreamReader(stream2, StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occured while loading settings config " + this.SETTINGS_ID.m_214299_(), (Throwable)e);
                        VariantSettings.resetSettings();
                    }
                }
                VariantWeights.applyBlacklists();
            }

            private void applyWeight(ResourceLocation identifier, Reader reader) {
                String target = identifier.m_135815_().substring(8, identifier.m_135815_().length() - 5);
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element.getAsJsonObject().size() != 0 && element.getAsJsonObject().has("weights")) {
                    Map weights = element.getAsJsonObject().get("weights").getAsJsonObject().asMap();
                    HashMap<String, Integer> weightsConverted = new HashMap<String, Integer>();
                    for (Map.Entry entry : weights.entrySet()) {
                        weightsConverted.put(entry.getKey().toString(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                    VariantWeights.setWeight(target, weightsConverted);
                }
            }

            private void applyBlacklist(ResourceLocation identifier, Reader reader) {
                String target = identifier.m_135815_().substring(10, identifier.m_135815_().length() - 5);
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element.getAsJsonObject().size() != 0 && element.getAsJsonObject().has("blacklist")) {
                    JsonArray blacklist = element.getAsJsonObject().get("blacklist").getAsJsonArray();
                    for (JsonElement entry : blacklist) {
                        VariantBlacklist.blacklistVariant(target, entry.getAsString());
                    }
                }
            }

            private void applySettings(Reader reader) {
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element.getAsJsonObject().size() != 0) {
                    if (element.getAsJsonObject().has("enable_muddy_pigs")) {
                        VariantSettings.setEnableMuddyPigs(element.getAsJsonObject().get("enable_muddy_pigs").getAsBoolean());
                    }
                    if (element.getAsJsonObject().has("wolf_breeding_chance")) {
                        VariantSettings.setWolfBreedingChance(element.getAsJsonObject().get("wolf_breeding_chance").getAsInt());
                    }
                }
            }
        });
    }
}

