/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser;

import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.api.EnchantingInfuserAPI;
import fuzs.enchantinginfuser.api.world.item.enchantment.EnchantStatsProvider;
import fuzs.enchantinginfuser.config.ServerConfig;
import fuzs.enchantinginfuser.data.ModBlockLootProvider;
import fuzs.enchantinginfuser.data.ModBlockTagsProvider;
import fuzs.enchantinginfuser.data.ModRecipeProvider;
import fuzs.enchantinginfuser.data.ModSpriteSourceProvider;
import fuzs.enchantinginfuser.init.ForgeModRegistry;
import fuzs.enchantinginfuser.integration.ApotheosisEnchantStatsProvider;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="enchantinginfuser")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnchantingInfuserForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ModConstructor.construct((String)"enchantinginfuser", EnchantingInfuser::new, (ContentRegistrationFlags[])new ContentRegistrationFlags[0]);
        ForgeModRegistry.touch();
        EnchantingInfuserForge.registerIntegration();
    }

    private static void registerIntegration() {
        EnchantingInfuser.CONFIG.getHolder(ServerConfig.class).accept(() -> {
            if (!((ServerConfig)EnchantingInfuser.CONFIG.get(ServerConfig.class)).apotheosisIntegration) {
                EnchantingInfuserAPI.setEnchantStatsProvider(EnchantStatsProvider.INSTANCE);
            } else if (ModLoaderEnvironment.INSTANCE.isModLoaded("apotheosis")) {
                EnchantingInfuserAPI.setEnchantStatsProvider(ApotheosisEnchantStatsProvider.INSTANCE);
            }
        });
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator dataGenerator = evt.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = evt.getLookupProvider();
        ExistingFileHelper fileHelper = evt.getExistingFileHelper();
        dataGenerator.addProvider(true, (DataProvider)new ModBlockLootProvider(packOutput, "enchantinginfuser"));
        dataGenerator.addProvider(true, (DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, "enchantinginfuser", fileHelper));
        dataGenerator.addProvider(true, (DataProvider)new ModRecipeProvider(packOutput));
        dataGenerator.addProvider(true, (DataProvider)new ModSpriteSourceProvider(packOutput, fileHelper));
    }
}

