/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.IUniverse;
import com.feed_the_beast.ftbl.client.teamsgui.GuiSelectTeam;
import com.feed_the_beast.ftbl.client.teamsgui.PublicTeamData;
import com.feed_the_beast.ftbl.lib.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class MessageSelectTeamGui
extends MessageToClient<MessageSelectTeamGui> {
    private List<PublicTeamData> teams;

    public MessageSelectTeamGui() {
    }

    public MessageSelectTeamGui(IUniverse universe, IForgePlayer player) {
        this.teams = new ArrayList<PublicTeamData>();
        for (IForgeTeam iForgeTeam : universe.getTeams()) {
            this.teams.add(new PublicTeamData(iForgeTeam, iForgeTeam.hasStatus(player, EnumTeamStatus.INVITED)));
        }
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    public void fromBytes(ByteBuf io) {
        int s = io.readInt();
        this.teams = new ArrayList<PublicTeamData>(s);
        while (--s >= 0) {
            this.teams.add(new PublicTeamData(io));
        }
    }

    public void toBytes(ByteBuf io) {
        io.writeInt(this.teams.size());
        for (PublicTeamData t : this.teams) {
            t.write(io);
        }
    }

    @Override
    public void onMessage(MessageSelectTeamGui m, EntityPlayer player) {
        new GuiSelectTeam(m.teams).openGui();
    }
}

