/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.EnumReloadType;
import com.feed_the_beast.ftbl.api.IFTBLibPlugin;
import com.feed_the_beast.ftbl.api.ISyncData;
import com.feed_the_beast.ftbl.api_impl.PackMode;
import com.feed_the_beast.ftbl.api_impl.SharedClientData;
import com.feed_the_beast.ftbl.api_impl.SharedServerData;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.util.LMNetUtils;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class MessageReload
extends MessageToClient<MessageReload> {
    private int typeID;
    private NBTTagCompound syncData;
    private String currentMode;
    private UUID universeID;

    public MessageReload() {
    }

    public MessageReload(EnumReloadType t, NBTTagCompound sync) {
        this.typeID = t.ordinal();
        this.syncData = sync;
        this.currentMode = SharedServerData.INSTANCE.getPackMode().func_176610_l();
        this.universeID = SharedServerData.INSTANCE.getUniverseID();
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    public void toBytes(ByteBuf io) {
        io.writeByte(this.typeID);
        ByteBufUtils.writeTag((ByteBuf)io, (NBTTagCompound)this.syncData);
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.currentMode);
        LMNetUtils.writeUUID(io, this.universeID);
    }

    public void fromBytes(ByteBuf io) {
        this.typeID = io.readUnsignedByte();
        this.syncData = ByteBufUtils.readTag((ByteBuf)io);
        this.currentMode = ByteBufUtils.readUTF8String((ByteBuf)io);
        this.universeID = LMNetUtils.readUUID(io);
    }

    @Override
    public void onMessage(MessageReload m, EntityPlayer player) {
        long ms = System.currentTimeMillis();
        EnumReloadType type = EnumReloadType.values()[m.typeID];
        SharedClientData.INSTANCE.universeID = m.universeID;
        SharedClientData.INSTANCE.currentMode = new PackMode(m.currentMode);
        for (String key : m.syncData.func_150296_c()) {
            ISyncData nbt = FTBLibModCommon.SYNCED_DATA.get(key);
            if (nbt == null) continue;
            nbt.readSyncData(m.syncData.func_74775_l(key));
        }
        if (type.reload(Side.CLIENT)) {
            for (IFTBLibPlugin plugin : FTBLibIntegrationInternal.API.getAllPlugins()) {
                plugin.onReload(Side.CLIENT, (ICommandSender)player, type);
            }
            if (type != EnumReloadType.LOGIN) {
                FTBLibLang.RELOAD_CLIENT.printChat((ICommandSender)player, System.currentTimeMillis() - ms + "ms");
            }
            FTBLibFinals.LOGGER.info("Current Mode: " + FTBLibIntegrationInternal.API.getClientData().getPackMode().func_176610_l());
        }
    }
}

