/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.gui.ButtonLM;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLM;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.TextBoxLM;
import com.feed_the_beast.ftbl.lib.gui.misc.IGuiFieldCallback;

public class GuiConfigValueField
extends GuiLM {
    private final IConfigValue defValue;
    private final IConfigValue value;
    private final IGuiFieldCallback callback;
    private final ButtonLM buttonCancel;
    private final ButtonLM buttonAccept;
    private final TextBoxLM textBox;

    GuiConfigValueField(IConfigValue val, IGuiFieldCallback c) {
        super(200, 60);
        this.defValue = val.copy();
        this.value = val.copy();
        this.callback = c;
        int bsize = this.getWidth() / 2 - 3;
        this.buttonCancel = new ButtonLM(2, this.getHeight() - 28, bsize, 26, GuiLang.BUTTON_CANCEL.translate(new Object[0])){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiConfigValueField.this.callback.onCallback(GuiConfigValueField.this.defValue, false);
            }

            @Override
            public int renderTitleInCenter(IGui gui) {
                return gui.getTextColor();
            }
        };
        this.buttonCancel.setIcon(ButtonLM.DEFAULT_BACKGROUND);
        this.buttonAccept = new ButtonLM(this.getWidth() - bsize - 2, this.getHeight() - 28, bsize, 26, GuiLang.BUTTON_ACCEPT.translate(new Object[0])){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                if (GuiConfigValueField.this.value.setValueFromString(GuiConfigValueField.this.textBox.getText(), false)) {
                    GuiConfigValueField.this.callback.onCallback(GuiConfigValueField.this.value, true);
                }
            }

            @Override
            public int renderTitleInCenter(IGui gui) {
                return gui.getTextColor();
            }
        };
        this.buttonAccept.setIcon(ButtonLM.DEFAULT_BACKGROUND);
        this.textBox = new TextBoxLM(2, 2, this.getWidth() - 4, 28){

            @Override
            public boolean isValid(String txt) {
                return GuiConfigValueField.this.value.setValueFromString(txt, true);
            }

            @Override
            public void onTextChanged(IGui gui) {
                ((GuiConfigValueField)GuiConfigValueField.this).textBox.textColor = GuiConfigValueField.this.value.getColor();
            }

            @Override
            public void onEnterPressed(IGui gui) {
                GuiConfigValueField.this.buttonAccept.onClicked(GuiConfigValueField.this, MouseButton.LEFT);
            }
        };
        this.textBox.writeText(this, val.toString());
        this.textBox.setFocused(true);
        this.textBox.background = ButtonLM.DEFAULT_BACKGROUND;
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
        this.add(this.textBox);
    }

    @Override
    public void drawBackground() {
        this.getIcon(this).draw(this);
    }

    @Override
    public IDrawableObject getIcon(IGui gui) {
        return DEFAULT_BACKGROUND;
    }
}

