/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib;

import com.feed_the_beast.ftbl.lib.ILangKeyContainer;
import com.feed_the_beast.ftbl.lib.LangKey;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import java.util.EnumMap;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class EnumDyeColorHelper
implements ILangKeyContainer {
    public static final EnumMap<EnumDyeColor, EnumDyeColorHelper> HELPERS = new EnumMap(EnumDyeColor.class);
    private final EnumDyeColor dye;
    private final LangKey langKey;
    private final String oreName;

    private EnumDyeColorHelper(EnumDyeColor col) {
        this.dye = col;
        this.langKey = new LangKey("item.fireworksCharge." + col.func_176762_d());
        this.oreName = LMStringUtils.firstUppercase(col.func_176762_d());
    }

    public static EnumDyeColorHelper get(EnumDyeColor dye) {
        return HELPERS.get(dye);
    }

    public ItemStack getDye(int s) {
        return new ItemStack(Items.field_151100_aR, s, this.dye.func_176767_b());
    }

    public String toString() {
        return this.dye.func_176610_l();
    }

    public int hashCode() {
        return this.dye.ordinal();
    }

    public EnumDyeColor getDye() {
        return this.dye;
    }

    @Override
    public LangKey getLangKey() {
        return this.langKey;
    }

    public String getOreName() {
        return this.oreName;
    }

    public String getDyeName() {
        return "dye" + this.getOreName();
    }

    public String getGlassName() {
        return "blockGlass" + this.getOreName();
    }

    public String getPaneName() {
        return "paneGlass" + this.getOreName();
    }

    static {
        for (EnumDyeColor c : EnumDyeColor.values()) {
            HELPERS.put(c, new EnumDyeColorHelper(c));
        }
    }
}

