/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl;

import com.feed_the_beast.ftbl.FTBLibConfig;
import com.feed_the_beast.ftbl.api.IDataProvider;
import com.feed_the_beast.ftbl.api.IFTBLibPlugin;
import com.feed_the_beast.ftbl.api.IFTBLibRegistry;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.api.IRankConfig;
import com.feed_the_beast.ftbl.api.ISyncData;
import com.feed_the_beast.ftbl.api.IUniverse;
import com.feed_the_beast.ftbl.api.config.IConfigContainer;
import com.feed_the_beast.ftbl.api.config.IConfigFile;
import com.feed_the_beast.ftbl.api.config.IConfigFileProvider;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.config.IConfigValueProvider;
import com.feed_the_beast.ftbl.api.gui.IContainerProvider;
import com.feed_the_beast.ftbl.api.info.IInfoTextLineProvider;
import com.feed_the_beast.ftbl.api_impl.LMRecipes;
import com.feed_the_beast.ftbl.api_impl.SharedServerData;
import com.feed_the_beast.ftbl.client.EnumNotificationDisplay;
import com.feed_the_beast.ftbl.lib.NBTDataStorage;
import com.feed_the_beast.ftbl.lib.config.ConfigFile;
import com.feed_the_beast.ftbl.lib.config.ConfigKey;
import com.feed_the_beast.ftbl.lib.config.PropertyBlockState;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.config.PropertyByte;
import com.feed_the_beast.ftbl.lib.config.PropertyColor;
import com.feed_the_beast.ftbl.lib.config.PropertyDouble;
import com.feed_the_beast.ftbl.lib.config.PropertyEntityClass;
import com.feed_the_beast.ftbl.lib.config.PropertyInt;
import com.feed_the_beast.ftbl.lib.config.PropertyItemStack;
import com.feed_the_beast.ftbl.lib.config.PropertyJson;
import com.feed_the_beast.ftbl.lib.config.PropertyList;
import com.feed_the_beast.ftbl.lib.config.PropertyNull;
import com.feed_the_beast.ftbl.lib.config.PropertyShort;
import com.feed_the_beast.ftbl.lib.config.PropertyString;
import com.feed_the_beast.ftbl.lib.config.PropertyStringEnum;
import com.feed_the_beast.ftbl.lib.config.PropertyTextComponent;
import com.feed_the_beast.ftbl.lib.info.InfoExtendedTextLine;
import com.feed_the_beast.ftbl.lib.info.InfoHrLine;
import com.feed_the_beast.ftbl.lib.info.InfoImageLine;
import com.feed_the_beast.ftbl.lib.info.InfoListLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.info.InfoPageHelper;
import com.feed_the_beast.ftbl.lib.info.InfoTextLineString;
import com.feed_the_beast.ftbl.lib.info.ItemListLine;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.internal.FTBLibNotifications;
import com.feed_the_beast.ftbl.lib.net.MessageLM;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class FTBLibModCommon
implements IFTBLibRegistry {
    public static final Map<String, IConfigValueProvider> CONFIG_VALUE_PROVIDERS = new HashMap<String, IConfigValueProvider>();
    public static final Map<String, IConfigFile> CONFIG_FILES = new HashMap<String, IConfigFile>();
    public static final Map<UUID, IConfigContainer> TEMP_SERVER_CONFIG = new HashMap<UUID, IConfigContainer>();
    public static final Map<ResourceLocation, IContainerProvider> GUI_CONTAINER_PROVIDERS = new HashMap<ResourceLocation, IContainerProvider>();
    public static final Map<String, ISyncData> SYNCED_DATA = new HashMap<String, ISyncData>();
    public static final Map<ResourceLocation, IDataProvider<IUniverse>> DATA_PROVIDER_UNIVERSE = new HashMap<ResourceLocation, IDataProvider<IUniverse>>();
    public static final Map<ResourceLocation, IDataProvider<IForgePlayer>> DATA_PROVIDER_PLAYER = new HashMap<ResourceLocation, IDataProvider<IForgePlayer>>();
    public static final Map<ResourceLocation, IDataProvider<IForgeTeam>> DATA_PROVIDER_TEAM = new HashMap<ResourceLocation, IDataProvider<IForgeTeam>>();
    private static final Map<String, IRankConfig> RANK_CONFIGS = new HashMap<String, IRankConfig>();
    public static final Map<String, IRankConfig> RANK_CONFIGS_MIRROR = Collections.unmodifiableMap(RANK_CONFIGS);

    public void preInit() {
        this.addOptionalServerMod("ftbl");
        this.addConfigFileProvider("ftbl", () -> new File(LMUtils.folderLocal, "ftbl.json"));
        this.addConfig("ftbl", "teams.autocreate_on_login", (IConfigValue)FTBLibConfig.AUTOCREATE_TEAMS);
        this.addConfig("ftbl", "teams.mirror_ftb_commands", (IConfigValue)FTBLibConfig.MIRROR_FTB_COMMANDS);
        this.addConfigValueProvider("null", () -> PropertyNull.INSTANCE);
        this.addConfigValueProvider("list", () -> new PropertyList("null"));
        this.addConfigValueProvider("bool", PropertyBool::new);
        this.addConfigValueProvider("byte", PropertyByte::new);
        this.addConfigValueProvider("short", PropertyShort::new);
        this.addConfigValueProvider("int", PropertyInt::new);
        this.addConfigValueProvider("double", PropertyDouble::new);
        this.addConfigValueProvider("string", PropertyString::new);
        this.addConfigValueProvider("color", PropertyColor::new);
        this.addConfigValueProvider("enum", PropertyStringEnum::new);
        this.addConfigValueProvider("json", PropertyJson::new);
        this.addConfigValueProvider("blockstate", PropertyBlockState::new);
        this.addConfigValueProvider("item_stack", PropertyItemStack::new);
        this.addConfigValueProvider("text_component", PropertyTextComponent::new);
        this.addConfigValueProvider("entity_class_list", PropertyEntityClass::new);
        this.addNotification(FTBLibNotifications.RELOAD_CLIENT_CONFIG);
        this.addNotification(FTBLibNotifications.NEW_TEAM_MESSAGE);
        this.addInfoTextLine("img", (page, json) -> new InfoImageLine(json));
        this.addInfoTextLine("image", (page, json) -> new InfoImageLine(json));
        this.addInfoTextLine("text_component", (page, json) -> new InfoExtendedTextLine(json));
        this.addInfoTextLine("text", (page, json) -> new InfoTextLineString(json));
        this.addInfoTextLine("list", InfoListLine::new);
        this.addInfoTextLine("hr", (page, json) -> new InfoHrLine(json));
        this.addInfoTextLine("item_list", (page, json) -> new ItemListLine(json));
        for (IFTBLibPlugin plugin : FTBLibIntegrationInternal.API.getAllPlugins()) {
            plugin.registerCommon(this);
        }
    }

    public void postInit() {
        for (IFTBLibPlugin plugin : FTBLibIntegrationInternal.API.getAllPlugins()) {
            plugin.registerRecipes(new LMRecipes());
        }
    }

    public void loadRegistries() {
    }

    public void spawnDust(World worldObj, double x, double y, double z, int i) {
    }

    @Override
    public void addConfigFileProvider(String id, IConfigFileProvider provider) {
        if (id.charAt(0) != '-') {
            id = id.toLowerCase();
            ConfigFile configFile = new ConfigFile((ITextComponent)new TextComponentString(id), provider);
            CONFIG_FILES.put(id, configFile);
        }
    }

    @Override
    public void addConfigValueProvider(String id, IConfigValueProvider provider) {
        CONFIG_VALUE_PROVIDERS.put(id.toLowerCase(), provider);
    }

    @Override
    public void addConfig(String file, IConfigKey key, IConfigValue value) {
        IConfigFile configFile = CONFIG_FILES.get(file);
        if (configFile == null) {
            configFile = new ConfigFile((ITextComponent)new TextComponentString(file), ConfigFile.NULL_FILE_PROVIDER);
            CONFIG_FILES.put(file, configFile);
        }
        configFile.add(key, value);
    }

    @Override
    public void addOptionalServerMod(String mod) {
        SharedServerData.INSTANCE.optionalServerMods.add(mod);
    }

    @Override
    public void addNotification(INotification notification) {
        SharedServerData.INSTANCE.notifications.put(notification.getId(), notification);
    }

    @Override
    public void addGuiContainer(ResourceLocation id, IContainerProvider provider) {
        GUI_CONTAINER_PROVIDERS.put(id, provider);
    }

    @Override
    public void addInfoTextLine(String id, IInfoTextLineProvider provider) {
        InfoPageHelper.INFO_TEXT_LINE_PROVIDERS.put(id.toLowerCase(), provider);
    }

    @Override
    public void addSyncData(String mod, ISyncData data) {
        SYNCED_DATA.put(mod, data);
    }

    @Override
    public void addUniverseDataProvider(ResourceLocation id, IDataProvider<IUniverse> provider) {
        DATA_PROVIDER_UNIVERSE.put(id, provider);
    }

    @Override
    public void addPlayerDataProvider(ResourceLocation id, IDataProvider<IForgePlayer> provider) {
        DATA_PROVIDER_PLAYER.put(id, provider);
    }

    @Override
    public void addTeamDataProvider(ResourceLocation id, IDataProvider<IForgeTeam> provider) {
        DATA_PROVIDER_TEAM.put(id, provider);
    }

    @Override
    public void addRankConfig(String id, IConfigValue defPlayer, IConfigValue defOP, String ... description) {
        Preconditions.checkArgument((!RANK_CONFIGS.containsKey(id) ? 1 : 0) != 0, (Object)("Duplicate RankConfig ID found: " + id));
        RankConfig c = new RankConfig(id, defPlayer, defOP, new String[0]);
        c.setInfo(description);
        RANK_CONFIGS.put(c.func_176610_l(), c);
    }

    public void loadAllFiles() {
        CONFIG_FILES.values().forEach(IConfigFile::load);
    }

    public void saveAllFiles() {
        CONFIG_FILES.values().forEach(IConfigFile::save);
    }

    public void reloadConfig(boolean startup) {
        this.loadAllFiles();
        JsonElement overridesE = LMJsonUtils.fromJson(new File(LMUtils.folderModpack, "overrides.json"));
        if (overridesE.isJsonObject()) {
            overridesE.getAsJsonObject().entrySet().forEach(entry -> {
                IConfigFile file;
                if (((JsonElement)entry.getValue()).isJsonObject() && (file = CONFIG_FILES.get(entry.getKey())) != null) {
                    file.func_152753_a((JsonElement)entry.getValue());
                }
            });
        }
        this.saveAllFiles();
        for (IFTBLibPlugin plugin : FTBLibIntegrationInternal.API.getAllPlugins()) {
            plugin.configLoaded(startup);
        }
    }

    public void worldLoaded() {
    }

    @Nullable
    public <T> NBTDataStorage createDataStorage(T owner, Map<ResourceLocation, IDataProvider<T>> map) {
        NBTDataStorage storage = new NBTDataStorage();
        map.forEach((key, value) -> {
            try {
                storage.add((ResourceLocation)key, value.getData(owner));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        return storage.isEmpty() ? null : storage;
    }

    public IConfigFile getClientConfig() {
        return null;
    }

    public void handleClientMessage(MessageLM<?> message) {
    }

    public void displayInfoGui(InfoPage page) {
    }

    public void displayNotification(EnumNotificationDisplay display, INotification n) {
    }

    private static class RankConfig
    extends ConfigKey
    implements IRankConfig {
        private final IConfigValue defaultOPValue;

        private RankConfig(String s, IConfigValue def, IConfigValue defOP, String ... info) {
            super(s, def);
            this.defaultOPValue = def.copy();
            this.defaultOPValue.func_152753_a(defOP.func_151003_a());
            this.setInfo(info);
        }

        @Override
        public IConfigValue getDefOPValue() {
            return this.defaultOPValue;
        }
    }
}

