/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.potion;

import com.google.common.base.Predicate;
import crazypants.enderzoo.EnderZoo;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.potion.FloatingPotion;
import java.lang.reflect.Method;
import jline.internal.Log;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class Potions {
    private static final String WITHERING = "withering";
    private static final String WITHERING_LONG = "witheringLong";
    private static final String CONFUSION = "confusion";
    private static final String CONFUSION_LONG = "confusionLong";
    private static final String FLOATING = "floating";
    private static final String FLOATING_TWO = "floatingTwo";
    private static final String FLOATING_LONG = "floatingLong";
    private PotionType withering = new PotionType("withering", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 900)});
    private PotionType witheringLong = new PotionType("withering", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 2400)});
    private PotionType confusion = new PotionType("confusion", new PotionEffect[]{new PotionEffect(MobEffects.field_76431_k, 900)});
    private PotionType confusionLong = new PotionType("confusion", new PotionEffect[]{new PotionEffect(MobEffects.field_76431_k, 2400)});
    private PotionType floating;
    private PotionType floatingLong;
    private PotionType floatingTwo;
    private Method regTypeConvMethod;
    private FloatingPotion floatingPotion;

    public Potions() {
        if (Config.floatingPotionEnabled) {
            this.floatingPotion = FloatingPotion.create();
            this.floating = new PotionType(FLOATING, new PotionEffect[]{new PotionEffect((Potion)this.floatingPotion, Config.floatingPotionDuration)});
            this.floatingLong = new PotionType(FLOATING, new PotionEffect[]{new PotionEffect((Potion)this.floatingPotion, Config.floatingPotionDurationLong)});
            this.floatingTwo = new PotionType(FLOATING, new PotionEffect[]{new PotionEffect((Potion)this.floatingPotion, Config.floatingPotionTwoDuration, 1)});
        }
        try {
            this.regTypeConvMethod = ReflectionHelper.findMethod(PotionHelper.class, null, (String[])new String[]{"registerPotionTypeConversion", "func_185204_a"}, (Class[])new Class[]{PotionType.class, Predicate.class, PotionType.class});
        }
        catch (Exception e) {
            Log.error((Object[])new Object[]{"Could not find method to register potions. Potions will not be brewable."});
            e.printStackTrace();
        }
    }

    public void registerPotions() {
        ItemPredicateInstance redstone = new ItemPredicateInstance(Items.field_151137_ax);
        ItemPredicateInstance glowstone = new ItemPredicateInstance(Items.field_151114_aO);
        PotionType.field_185176_a.func_177775_a(Config.witherPotionID, (Object)new ResourceLocation(WITHERING), (Object)this.withering);
        PotionType.field_185176_a.func_177775_a(Config.witherPotionLongID, (Object)new ResourceLocation(WITHERING_LONG), (Object)this.witheringLong);
        ItemPredicateInstance witheringDust = new ItemPredicateInstance(EnderZoo.itemWitheringDust);
        this.registerPotionTypeConversion(PotionTypes.field_185233_e, witheringDust, this.withering);
        this.registerPotionTypeConversion(this.withering, redstone, this.witheringLong);
        PotionType.field_185176_a.func_177775_a(Config.confusingPotionID, (Object)new ResourceLocation(CONFUSION), (Object)this.confusion);
        PotionType.field_185176_a.func_177775_a(Config.confusingPotionLongID, (Object)new ResourceLocation(CONFUSION_LONG), (Object)this.confusionLong);
        ItemPredicateInstance confusionDust = new ItemPredicateInstance(EnderZoo.itemConfusingDust);
        this.registerPotionTypeConversion(PotionTypes.field_185233_e, confusionDust, this.confusion);
        this.registerPotionTypeConversion(this.confusion, redstone, this.confusionLong);
        if (Config.floatingPotionEnabled) {
            PotionType.field_185176_a.func_177775_a(Config.floatingPotionID, (Object)new ResourceLocation(FLOATING), (Object)this.floating);
            PotionType.field_185176_a.func_177775_a(Config.floatingPotionLongID, (Object)new ResourceLocation(FLOATING_LONG), (Object)this.floatingLong);
            PotionType.field_185176_a.func_177775_a(Config.floatingPotionTwoID, (Object)new ResourceLocation(FLOATING_TWO), (Object)this.floatingTwo);
            ItemPredicateInstance owlEgg = new ItemPredicateInstance(EnderZoo.itemOwlEgg);
            this.registerPotionTypeConversion(PotionTypes.field_185233_e, owlEgg, this.floating);
            this.registerPotionTypeConversion(this.floating, redstone, this.floatingLong);
            this.registerPotionTypeConversion(this.floating, glowstone, this.floatingTwo);
        }
    }

    private void registerPotionTypeConversion(PotionType input, Predicate<ItemStack> reagentPredicate, PotionType output) {
        if (this.regTypeConvMethod == null) {
            return;
        }
        try {
            this.regTypeConvMethod.invoke(null, input, reagentPredicate, output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PotionType getWithering() {
        return this.withering;
    }

    public PotionType getWitheringLong() {
        return this.witheringLong;
    }

    public PotionType getConfusion() {
        return this.confusion;
    }

    public PotionType getConfusionLong() {
        return this.confusionLong;
    }

    public PotionType getFloating() {
        return this.floating;
    }

    public PotionType getFloatingLong() {
        return this.floatingLong;
    }

    public PotionType getFloatingTwo() {
        return this.floatingTwo;
    }

    public FloatingPotion getFloatingPotion() {
        return this.floatingPotion;
    }

    static class ItemPredicateInstance
    implements Predicate<ItemStack> {
        private final Item item;
        private final int meta;

        public ItemPredicateInstance(Item itemIn) {
            this(itemIn, -1);
        }

        public ItemPredicateInstance(Item itemIn, int metaIn) {
            this.item = itemIn;
            this.meta = metaIn;
        }

        public boolean apply(ItemStack p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_.func_77973_b() == this.item && (this.meta == -1 || this.meta == p_apply_1_.func_77960_j());
        }
    }
}

