/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.EntityFallenMount;
import crazypants.enderzoo.entity.EntityUtil;
import crazypants.enderzoo.entity.IEnderZooMob;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.entity.SpawnUtil;
import crazypants.enderzoo.entity.ai.EntityAIMountedArrowAttack;
import crazypants.enderzoo.entity.ai.EntityAIMountedAttackOnCollide;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityFallenKnight
extends EntitySkeleton
implements IEnderZooMob {
    public static final int EGG_FG_COL = 3562021;
    public static final int EGG_BG_COL = 0xA0A0A0;
    public static String NAME = "FallenKnight";
    private static final double ATTACK_MOVE_SPEED = Config.fallenKnightChargeSpeed;
    private EntityAIMountedArrowAttack aiArrowAttack;
    private EntityAIMountedAttackOnCollide aiAttackOnCollide;
    private final EntityAIBreakDoor breakDoorAI = new EntityAIBreakDoor((EntityLiving)this);
    private boolean canBreakDoors = false;
    private EntityLivingBase lastAttackTarget = null;
    private boolean firstUpdate = true;
    private boolean isMounted = false;
    private boolean spawned = false;

    public EntityFallenKnight(World world) {
        super(world);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(Config.fallenKnightFollowRange);
        MobInfo.FALLEN_KNIGHT.applyAttributes((EntityLivingBase)this);
    }

    public void func_85036_m() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.getAiAttackOnCollide());
        this.field_70714_bg.func_85156_a((EntityAIBase)this.getAiArrowAttack());
        if (this.isRanged()) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiArrowAttack());
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiAttackOnCollide());
        }
    }

    public EntityAIMountedArrowAttack getAiArrowAttack() {
        if (this.aiArrowAttack == null) {
            this.aiArrowAttack = new EntityAIMountedArrowAttack((IRangedAttackMob)this, ATTACK_MOVE_SPEED, EntityFallenMount.MOUNTED_ATTACK_MOVE_SPEED, Config.fallenKnightRangedMinAttackPause, Config.fallenKnightRangedMaxAttackPause, Config.fallenKnightRangedMaxRange, Config.fallKnightMountedArchesMaintainDistance);
        }
        return this.aiArrowAttack;
    }

    public EntityAIMountedAttackOnCollide getAiAttackOnCollide() {
        if (this.aiAttackOnCollide == null) {
            this.aiAttackOnCollide = new EntityAIMountedAttackOnCollide((EntityCreature)this, EntityPlayer.class, ATTACK_MOVE_SPEED, EntityFallenMount.MOUNTED_ATTACK_MOVE_SPEED, false);
        }
        return this.aiAttackOnCollide;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.firstUpdate && !this.field_70170_p.field_72995_K) {
            this.spawnMount();
        }
        if (this.isRidingMount()) {
            EntityLiving entLiving = (EntityLiving)this.func_184187_bx();
            if (this.lastAttackTarget != this.func_70638_az() || this.firstUpdate) {
                EntityUtil.cancelCurrentTasks(entLiving);
                this.lastAttackTarget = this.func_70638_az();
            }
        }
        this.firstUpdate = false;
        if (!this.isMounted == this.isRidingMount()) {
            this.getAiAttackOnCollide().func_75251_c();
            this.getAiArrowAttack().func_75251_c();
            this.func_70661_as().func_75499_g();
            this.isMounted = this.isRidingMount();
        }
        if (this.func_70027_ad() && this.isRidingMount()) {
            this.func_184187_bx().func_70015_d(8);
        }
        if (Config.fallenKnightArchersSwitchToMelee && (!this.isMounted || !Config.fallKnightMountedArchesMaintainDistance) && this.func_70638_az() != null && this.isRanged() && this.func_70068_e((Entity)this.func_70638_az()) < 5.0) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getSwordForLevel(this.getRandomEquipmentLevel()));
        }
    }

    private boolean isRidingMount() {
        return this.func_184218_aH() && this.func_184187_bx().getClass() == EntityFallenMount.class;
    }

    protected void func_70623_bb() {
        Entity mount = this.func_184187_bx();
        super.func_70623_bb();
        if (this.field_70128_L && mount != null) {
            mount.func_70106_y();
        }
    }

    private void spawnMount() {
        if (this.func_184218_aH() || !this.spawned) {
            return;
        }
        EntityFallenMount mount = null;
        if (Config.fallenMountEnabled && this.field_70146_Z.nextFloat() <= Config.fallenKnightChanceMounted) {
            mount = new EntityFallenMount(this.field_70170_p);
            mount.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            DifficultyInstance di = this.field_70170_p.func_175649_E(new BlockPos((Entity)mount));
            mount.func_180482_a(di, null);
            if (!SpawnUtil.isSpaceAvailableForSpawn(this.field_70170_p, (EntityLiving)mount, false)) {
                mount = null;
            }
        }
        if (mount != null) {
            this.func_98053_h(false);
            this.setCanBreakDoors(false);
            this.field_70170_p.func_72838_d((Entity)mount);
            this.func_184220_m((Entity)mount);
        }
    }

    private boolean isRanged() {
        ItemStack itemstack = this.func_184586_b(EnumHand.MAIN_HAND);
        return itemstack != null && itemstack.func_77973_b() == Items.field_151031_f;
    }

    private void addRandomArmor() {
        float occupiedDiffcultyMultiplier = EntityUtil.getDifficultyMultiplierForLocation(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        int equipmentLevel = this.getRandomEquipmentLevel(occupiedDiffcultyMultiplier);
        int armorLevel = equipmentLevel;
        if (armorLevel == 1) {
            ++armorLevel;
        }
        float chancePerPiece = this.isHardDifficulty() ? Config.fallenKnightChancePerArmorPieceHard : Config.fallenKnightChancePerArmorPiece;
        chancePerPiece *= 1.0f + occupiedDiffcultyMultiplier;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            Item item;
            ItemStack itemStack = this.func_184582_a(slot);
            if (itemStack != null || !(this.field_70146_Z.nextFloat() <= chancePerPiece) || (item = EntityLiving.func_184636_a((EntityEquipmentSlot)slot, (int)armorLevel)) == null) continue;
            ItemStack stack = new ItemStack(item);
            if (armorLevel == 0) {
                ((ItemArmor)item).func_82813_b(stack, 0);
            }
            this.func_184201_a(slot, stack);
        }
        if (this.field_70146_Z.nextFloat() > Config.fallenKnightRangedRatio) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getSwordForLevel(equipmentLevel));
            if (Math.random() <= Config.fallenKnightChanceShield) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.getShieldForLevel(this.getRandomEquipmentLevel()));
            }
        } else {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        }
    }

    private int getRandomEquipmentLevel() {
        return this.getRandomEquipmentLevel(EntityUtil.getDifficultyMultiplierForLocation(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v));
    }

    private int getRandomEquipmentLevel(float occupiedDiffcultyMultiplier) {
        float chanceImprovedArmor = this.isHardDifficulty() ? Config.fallenKnightChanceArmorUpgradeHard : Config.fallenKnightChanceArmorUpgrade;
        chanceImprovedArmor *= 1.0f + occupiedDiffcultyMultiplier;
        int armorLevel = this.field_70146_Z.nextInt(2);
        for (int i = 0; i < 2; ++i) {
            if (!(this.field_70146_Z.nextFloat() <= chanceImprovedArmor)) continue;
            ++armorLevel;
        }
        return armorLevel;
    }

    protected boolean isHardDifficulty() {
        return EntityUtil.isHardDifficulty(this.field_70170_p);
    }

    private ItemStack getSwordForLevel(int swordLevel) {
        if (swordLevel < 2) {
            swordLevel += this.field_70146_Z.nextInt(this.isHardDifficulty() ? 3 : 2);
            swordLevel = Math.min(swordLevel, 2);
        }
        switch (swordLevel) {
            case 0: {
                return new ItemStack(Items.field_151041_m);
            }
            case 1: {
                return new ItemStack(Items.field_151052_q);
            }
            case 2: {
                return new ItemStack(Items.field_151040_l);
            }
            case 4: {
                return new ItemStack(Items.field_151048_u);
            }
        }
        return new ItemStack(Items.field_151040_l);
    }

    private ItemStack getShieldForLevel(int swordLevel) {
        return new ItemStack(Items.field_185159_cQ);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance di, IEntityLivingData livingData) {
        this.spawned = true;
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        this.func_189768_a(SkeletonType.NORMAL);
        this.addRandomArmor();
        this.func_180483_b(di);
        float f = di.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.setCanBreakDoors(this.field_70146_Z.nextFloat() < f * 0.1f);
        return livingData;
    }

    public void func_70014_b(NBTTagCompound root) {
        super.func_70014_b(root);
        root.func_74757_a("canBreakDoors", this.canBreakDoors);
    }

    public void func_70037_a(NBTTagCompound root) {
        super.func_70037_a(root);
        this.setCanBreakDoors(root.func_74767_n("canBreakDoors"));
    }

    private void setCanBreakDoors(boolean val) {
        if (this.canBreakDoors != val) {
            this.canBreakDoors = val;
            if (this.canBreakDoors) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoorAI);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoorAI);
            }
        }
    }

    protected void func_70628_a(boolean hitByPlayer, int lootingLevel) {
        int numDrops = this.field_70146_Z.nextInt(3 + lootingLevel);
        for (int i = 0; i < numDrops; ++i) {
            if (this.field_70146_Z.nextBoolean()) {
                this.func_145779_a(Items.field_151103_aS, 1);
                continue;
            }
            this.func_145779_a(Items.field_151078_bh, 1);
        }
    }
}

