/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.world.gen.feature;

import com.google.common.base.Predicate;
import com.valkyrieofnight.valkyrielib.util.WeightedBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMultiOreVein
extends WorldGenerator {
    private List<WeightedBlock> ores;
    private int veinSize;
    private final Predicate<IBlockState> predicate;

    public WorldGenMultiOreVein(List<WeightedBlock> ores, int veinSize) {
        this(ores, veinSize, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    }

    public WorldGenMultiOreVein(List<WeightedBlock> ores, int veinSize, Predicate<IBlockState> predicate) {
        this.ores = ores;
        this.veinSize = veinSize;
        this.predicate = predicate;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos p1) {
        BlockPos p2;
        Random r2 = new Random(worldIn.func_72905_C());
        int maxVeinLength = this.veinSize / 3;
        boolean boldLine = false;
        if (this.veinSize > 16) {
            p2 = this.getRandPointWithDistance(r2, p1, 16);
            boldLine = true;
        } else {
            p2 = this.getRandPointWithDistance(r2, p1, this.veinSize);
        }
        int totalPlaced = 0;
        while (totalPlaced < this.veinSize) {
        }
        return false;
    }

    public BlockPos getRandPointWithDistance(Random rand, BlockPos pointOne, int distance) {
        double theta = Math.PI * 2 * rand.nextDouble();
        double phi = Math.acos(2.0 * rand.nextDouble() - 1.0);
        int x = (int)((double)pointOne.func_177958_n() + (double)((float)distance * MathHelper.func_76126_a((float)((float)phi))) * Math.cos(theta));
        int y = (int)((double)pointOne.func_177956_o() + (double)((float)distance * MathHelper.func_76126_a((float)((float)phi))) * Math.sin(theta));
        int z = (int)((float)pointOne.func_177952_p() + (float)distance * MathHelper.func_76134_b((float)((float)phi)));
        return new BlockPos(x, y, z);
    }
}

