/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.client;

import com.valkyrieofnight.valkyrielib.util.TextureLoc;
import net.minecraft.util.ResourceLocation;

public class SizableBox {
    private final ResourceLocation texture;
    private TextureLoc[][] textureLocations;
    private int unitXSize;
    private int unitYSize;
    private boolean middleRepeatable;
    private int texWidth;
    private int texHeight;

    public SizableBox(ResourceLocation tex, int unitXSize, int unitYSize) {
        this.texture = tex;
        this.textureLocations = new TextureLoc[3][3];
        this.unitXSize = unitXSize;
        this.unitYSize = unitYSize;
        this.texWidth = 256;
        this.texHeight = 256;
    }

    public SizableBox(ResourceLocation tex, int unitXSize, int unitYSize, int texWidth, int texHeight) {
        this.texture = tex;
        this.textureLocations = new TextureLoc[3][3];
        this.unitXSize = unitXSize;
        this.unitYSize = unitYSize;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
    }

    public void setTextureLoc(BoxLocation loc, TextureLoc tex) {
        this.textureLocations[loc.y][loc.x] = tex;
    }

    public TextureLoc getTextureLoc(BoxLocation loc) {
        return this.textureLocations[loc.y][loc.x];
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getUnitX() {
        return this.unitXSize;
    }

    public int getUnitY() {
        return this.unitYSize;
    }

    public int getTexW() {
        return this.texWidth;
    }

    public int getTexH() {
        return this.texHeight;
    }

    public boolean getMiddleRepeatable() {
        return this.middleRepeatable;
    }

    public static enum BoxLocation {
        TOP_LEFT(0, 0),
        TOP_MID(0, 1),
        TOP_RIGHT(0, 2),
        MID_LEFT(1, 0),
        MID(1, 1),
        MID_RIGHT(1, 2),
        BOT_LEFT(2, 0),
        BOT_MID(2, 1),
        BOT_RIGHT(2, 2);

        public int x;
        public int y;

        private BoxLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

