/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.api.storage.IStorageScanner;
import mcjty.rftoolscontrol.api.parameters.BlockSide;
import mcjty.rftoolscontrol.api.parameters.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;

public class InventoryTools {
    public static int countItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, ItemStack itemMatcher, boolean oredict, int maxToCount) {
        if (itemHandler != null) {
            int cnt = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (!ItemStackTools.isValid((ItemStack)stack) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemMatcher) || maxToCount == -1 || (cnt += ItemStackTools.getStackSize((ItemStack)stack)) < maxToCount) continue;
                return maxToCount;
            }
            return cnt;
        }
        if (scanner != null) {
            int cnt = scanner.countItems(itemMatcher, true, oredict);
            if (maxToCount != -1 && cnt >= maxToCount) {
                return maxToCount;
            }
            return cnt;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ItemStack extractItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nullable Integer amount, boolean routable, boolean oredict, ItemStack itemMatcher, @Nullable Integer slot) {
        block14: {
            block13: {
                int n;
                block11: {
                    int n2;
                    block12: {
                        if (itemHandler == null) break block11;
                        if (slot != null) break block12;
                        if (ItemStackTools.isEmpty((ItemStack)itemMatcher)) break block13;
                        break block14;
                    }
                    if (ItemStackTools.isEmpty((ItemStack)itemMatcher)) {
                        int n3;
                        int n4 = slot;
                        if (amount == null) {
                            n3 = 64;
                            return itemHandler.extractItem(n4, n3, false);
                        }
                        n3 = amount;
                        return itemHandler.extractItem(n4, n3, false);
                    }
                    if (!ItemStack.func_179545_c((ItemStack)itemMatcher, (ItemStack)itemHandler.getStackInSlot(slot.intValue()))) {
                        return ItemStackTools.getEmptyStack();
                    }
                    int n5 = slot;
                    if (amount == null) {
                        n2 = itemMatcher.func_77976_d();
                        return itemHandler.extractItem(n5, n2, false);
                    }
                    n2 = amount;
                    return itemHandler.extractItem(n5, n2, false);
                }
                if (scanner == null) return ItemStackTools.getEmptyStack();
                if (amount == null) {
                    n = itemMatcher.func_77976_d();
                    return scanner.requestItem(itemMatcher, n, routable, oredict);
                }
                n = amount;
                return scanner.requestItem(itemMatcher, n, routable, oredict);
            }
            int i = 0;
            while (i < itemHandler.getSlots()) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (ItemStackTools.isValid((ItemStack)stack) && (amount == null || amount <= ItemStackTools.getStackSize((ItemStack)stack))) {
                    int n;
                    if (amount == null) {
                        n = 64;
                        return itemHandler.extractItem(i, n, false);
                    }
                    n = amount;
                    return itemHandler.extractItem(i, n, false);
                }
                ++i;
            }
            return ItemStackTools.getEmptyStack();
        }
        int i = 0;
        while (i < itemHandler.getSlots()) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (ItemStackTools.isValid((ItemStack)stack) && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemMatcher)) {
                int n;
                if (amount == null) {
                    n = itemMatcher.func_77976_d();
                    return itemHandler.extractItem(i, n, false);
                }
                n = amount;
                return itemHandler.extractItem(i, n, false);
            }
            ++i;
        }
        return ItemStackTools.getEmptyStack();
    }

    public static ItemStack tryExtractItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nullable Integer amount, boolean routable, boolean oredict, ItemStack itemMatcher, @Nullable Integer slot) {
        int cnt;
        if (itemHandler != null) {
            if (slot == null) {
                ItemStack stack;
                int i;
                if (ItemStackTools.isEmpty((ItemStack)itemMatcher)) {
                    for (i = 0; i < itemHandler.getSlots(); ++i) {
                        stack = itemHandler.getStackInSlot(i);
                        if (!ItemStackTools.isValid((ItemStack)stack) || amount != null && amount > ItemStackTools.getStackSize((ItemStack)stack)) continue;
                        return itemHandler.extractItem(i, amount == null ? 64 : amount, true);
                    }
                } else {
                    for (i = 0; i < itemHandler.getSlots(); ++i) {
                        stack = itemHandler.getStackInSlot(i);
                        if (!ItemStackTools.isValid((ItemStack)stack) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemMatcher)) continue;
                        return itemHandler.extractItem(i, amount == null ? itemMatcher.func_77976_d() : amount.intValue(), true);
                    }
                }
            } else {
                if (ItemStackTools.isEmpty((ItemStack)itemMatcher)) {
                    return itemHandler.extractItem(slot.intValue(), amount == null ? 64 : amount, true);
                }
                if (!ItemStack.func_179545_c((ItemStack)itemMatcher, (ItemStack)itemHandler.getStackInSlot(slot.intValue()))) {
                    return ItemStackTools.getEmptyStack();
                }
                return itemHandler.extractItem(slot.intValue(), amount == null ? itemMatcher.func_77976_d() : amount.intValue(), true);
            }
        }
        if (scanner != null && (cnt = scanner.countItems(itemMatcher, routable, oredict)) > 0) {
            ItemStack copy = itemMatcher.func_77946_l();
            ItemStackTools.setStackSize((ItemStack)copy, (int)Math.min(cnt, amount == null ? itemMatcher.func_77976_d() : amount.intValue()));
            return copy;
        }
        return ItemStackTools.getEmptyStack();
    }

    public static ItemStack insertItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nonnull ItemStack item, @Nullable Integer slot) {
        if (itemHandler != null) {
            if (slot == null) {
                return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)item, (boolean)false);
            }
            return itemHandler.insertItem(slot.intValue(), item, false);
        }
        if (scanner != null) {
            int cnt = scanner.insertItem(item);
            if (cnt > 0) {
                ItemStack copy = item.func_77946_l();
                ItemStackTools.setStackSize((ItemStack)copy, (int)cnt);
                return copy;
            }
            return ItemStackTools.getEmptyStack();
        }
        return item;
    }

    public static String inventoryToString(Inventory inv) {
        String s = StringUtils.left((String)inv.getSide().func_176610_l().toUpperCase(), (int)1);
        if (inv.getIntSide() == null) {
            s = s + "/*";
        } else {
            String is = StringUtils.left((String)inv.getIntSide().func_176610_l().toUpperCase(), (int)1);
            s = s + "/" + is;
        }
        if (inv.getNodeName() == null) {
            return s;
        }
        return inv.getNodeName() + " " + s;
    }

    @Nullable
    public static Inventory inventoryFromString(String s) {
        if (s == null) {
            return null;
        }
        int indexOf = s.lastIndexOf(47);
        if (indexOf == -1) {
            return null;
        }
        if (s.length() <= indexOf + 1) {
            return null;
        }
        EnumFacing side = InventoryTools.getSideFromChar(s.charAt(indexOf - 1));
        if (side == null) {
            return null;
        }
        EnumFacing intSide = InventoryTools.getSideFromChar(s.charAt(indexOf + 1));
        int indexSpace = s.lastIndexOf(32);
        if (indexSpace <= 0) {
            return new Inventory(null, side, intSide);
        }
        return new Inventory(s.substring(0, indexSpace), side, intSide);
    }

    public static EnumFacing getSideFromChar(char is) {
        switch (is) {
            case '*': {
                return null;
            }
            case 'D': {
                return EnumFacing.DOWN;
            }
            case 'U': {
                return EnumFacing.UP;
            }
            case 'W': {
                return EnumFacing.WEST;
            }
            case 'E': {
                return EnumFacing.EAST;
            }
            case 'S': {
                return EnumFacing.SOUTH;
            }
            case 'N': {
                return EnumFacing.NORTH;
            }
        }
        return null;
    }

    public static String blockSideToString(BlockSide bc) {
        String s = bc.getSide() == null ? "*" : StringUtils.left((String)bc.getSide().func_176610_l().toUpperCase(), (int)1);
        if (bc.getNodeName() == null) {
            return s;
        }
        return bc.getNodeName() + " " + s;
    }

    @Nullable
    public static BlockSide blockSideFromString(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return null;
        }
        EnumFacing side = InventoryTools.getSideFromChar(s.charAt(s.length() - 1));
        int indexOf = s.lastIndexOf(32);
        if (indexOf <= 0) {
            return new BlockSide(null, side);
        }
        return new BlockSide(s.substring(0, indexOf), side);
    }
}

