/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import lumien.randomthings.client.gui.elements.GuiCustomButton;
import lumien.randomthings.client.gui.elements.GuiStringList;
import lumien.randomthings.container.ContainerVoxelProjector;
import lumien.randomthings.lib.IStringCallback;
import lumien.randomthings.network.PacketHandler;
import lumien.randomthings.network.messages.MessageVoxelProjector;
import lumien.randomthings.tileentity.TileEntityVoxelProjector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiSlider;
import org.lwjgl.opengl.GL11;

public class GuiVoxelProjector
extends GuiContainer
implements IStringCallback {
    TileEntityVoxelProjector te;
    final ResourceLocation background = new ResourceLocation("randomthings:textures/gui/voxelProjector.png");
    final ResourceLocation buttons = new ResourceLocation("randomthings:textures/gui/voxelProjectorButtons.png");
    GuiCustomButton toggleAmbientLight;
    GuiCustomButton toggleRandomizer;
    GuiStringList availableModels;
    int oldRotation;
    int oldScale;
    int oldRotationSpeed;

    public GuiVoxelProjector(EntityPlayer player, World world, int x, int y, int z) {
        super((Container)new ContainerVoxelProjector(player, world, x, y, z));
        this.te = (TileEntityVoxelProjector)world.func_175625_s(new BlockPos(x, y, z));
        this.oldRotation = this.te.getModelRotation();
        this.oldScale = this.te.getScale();
        this.oldRotationSpeed = this.te.getRotationSpeed();
        this.field_146999_f = 230;
        this.field_147000_g = 219;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiSlider(0, this.field_147003_i + 5, 90, 120, 20, "Model Rotation: ", "", 0.0, 360.0, (double)this.te.getModelRotation(), false, true, new GuiSlider.ISlider(){

            public void onChangeSliderValue(GuiSlider slider) {
                int rotation = (int)Math.floor(slider.sliderValue * 360.0);
                GuiVoxelProjector.this.te.setModelRotation(rotation);
                if (rotation != GuiVoxelProjector.this.oldRotation) {
                    GuiVoxelProjector.this.oldRotation = (int)Math.floor(slider.sliderValue * 360.0);
                    MessageVoxelProjector message = new MessageVoxelProjector(GuiVoxelProjector.this.te.func_174877_v());
                    message.setModelRotation(rotation);
                    PacketHandler.INSTANCE.sendToServer(message);
                }
            }
        }));
        this.field_146292_n.add(new GuiSlider(1, this.field_147003_i + 5, 60, 120, 20, "Scale: ", "", 1.0, 20.0, (double)this.te.getScale(), false, true, new GuiSlider.ISlider(){

            public void onChangeSliderValue(GuiSlider slider) {
                int scale = Math.min(20, (int)Math.floor((slider.sliderValue + (double)0.05f) * 20.0));
                GuiVoxelProjector.this.te.setScale(scale);
                if (scale != GuiVoxelProjector.this.oldScale) {
                    GuiVoxelProjector.this.oldScale = scale;
                    MessageVoxelProjector message = new MessageVoxelProjector(GuiVoxelProjector.this.te.func_174877_v());
                    message.setScale(scale);
                    PacketHandler.INSTANCE.sendToServer(message);
                }
            }
        }));
        this.field_146292_n.add(new GuiSlider(2, this.field_147003_i + 5, 120, 120, 20, "Rotation Speed: ", "", 0.0, 40.0, (double)this.te.getRotationSpeed(), false, true, new GuiSlider.ISlider(){

            public void onChangeSliderValue(GuiSlider slider) {
                int rotationSpeed = (int)Math.floor(slider.sliderValue * 40.0);
                GuiVoxelProjector.this.te.setRotationSpeed(rotationSpeed);
                if (rotationSpeed != GuiVoxelProjector.this.oldRotationSpeed) {
                    GuiVoxelProjector.this.oldRotationSpeed = rotationSpeed;
                    MessageVoxelProjector message = new MessageVoxelProjector(GuiVoxelProjector.this.te.func_174877_v());
                    message.setRotationSpeed(rotationSpeed);
                    PacketHandler.INSTANCE.sendToServer(message);
                }
            }
        }));
        this.toggleAmbientLight = new GuiCustomButton((GuiScreen)this, 3, this.te.ambientLight(), this.field_147003_i + this.field_146999_f - 25, 60, 20, 20, "", this.buttons, 0, 0);
        this.toggleRandomizer = new GuiCustomButton((GuiScreen)this, 4, this.te.randomize(), this.field_147003_i + this.field_146999_f - 25, 85, 20, 20, "", this.buttons, 42, 0);
        this.field_146292_n.add(this.toggleAmbientLight);
        this.field_146292_n.add(this.toggleRandomizer);
        this.availableModels = new GuiStringList(this, Minecraft.func_71410_x(), 120, 50, this.field_147003_i + 5, 150, this.field_146294_l, this.field_146295_m, Lists.newArrayList());
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.background);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.voxelProjector.name", (Object[])new Object[0]), 3, 6, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.availableModels.drawScreen(mouseX, mouseY, partialTicks);
    }

    @Override
    public void pressed(String string) {
        MessageVoxelProjector message = new MessageVoxelProjector(this.te.func_174877_v());
        message.setModel(string);
        PacketHandler.INSTANCE.sendToServer(message);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        MessageVoxelProjector message;
        super.func_146284_a(button);
        if (button == this.toggleAmbientLight) {
            this.toggleAmbientLight.toggle();
            message = new MessageVoxelProjector(this.te.func_174877_v());
            message.setAmbientLight(this.toggleAmbientLight.getValue());
            PacketHandler.INSTANCE.sendToServer(message);
        }
        if (button == this.toggleRandomizer) {
            this.toggleRandomizer.toggle();
            message = new MessageVoxelProjector(this.te.func_174877_v());
            message.setRandomize(this.toggleRandomizer.getValue());
            PacketHandler.INSTANCE.sendToServer(message);
        }
    }

    public void setModelList(List<String> modelList) {
        this.availableModels.setList(modelList);
    }
}

