/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.util.Random;
import lumien.randomthings.block.BlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockIgniter
extends BlockBase {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    protected BlockIgniter() {
        super("igniter", Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(1.5f);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        return side == facing;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        boolean newPowered = worldIn.func_175687_A(pos) > 0;
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(newPowered)));
        if (powered && !newPowered) {
            IBlockState front = worldIn.func_180495_p(pos.func_177972_a(facing));
            if (front.func_177230_c() == Blocks.field_150480_ab) {
                worldIn.func_175698_g(pos.func_177972_a(facing));
            }
        } else if (newPowered && !powered) {
            if (worldIn.func_175623_d(pos.func_177972_a(facing))) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, new Random().nextFloat() * 0.4f + 0.8f);
                worldIn.func_175656_a(pos.func_177972_a(facing), Blocks.field_150480_ab.func_176223_P());
            }
        } else {
            return;
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultFacing(worldIn, pos, state);
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(worldIn.func_175687_A(pos) > 0)));
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
    }

    public IBlockState func_176203_a(int meta) {
        boolean powered = false;
        if (meta >= 6) {
            meta -= 6;
            powered = true;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i += 6;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }
}

