/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import mekanism.api.MekanismConfig;
import mekanism.common.Mekanism;
import mekanism.common.base.IGuiProvider;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.generators.common.inventory.container.ContainerBioGenerator;
import mekanism.generators.common.inventory.container.ContainerGasGenerator;
import mekanism.generators.common.inventory.container.ContainerHeatGenerator;
import mekanism.generators.common.inventory.container.ContainerNeutronCapture;
import mekanism.generators.common.inventory.container.ContainerReactorController;
import mekanism.generators.common.inventory.container.ContainerSolarGenerator;
import mekanism.generators.common.inventory.container.ContainerWindGenerator;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorFrame;
import mekanism.generators.common.tile.reactor.TileEntityReactorGlass;
import mekanism.generators.common.tile.reactor.TileEntityReactorLaserFocusMatrix;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.tile.reactor.TileEntityReactorNeutronCapture;
import mekanism.generators.common.tile.reactor.TileEntityReactorPort;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineValve;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class GeneratorsCommonProxy
implements IGuiProvider {
    public void registerRegularTileEntities() {
        GameRegistry.registerTileEntity(TileEntityReactorFrame.class, (String)"ReactorFrame");
        GameRegistry.registerTileEntity(TileEntityReactorGlass.class, (String)"ReactorGlass");
        GameRegistry.registerTileEntity(TileEntityReactorLaserFocusMatrix.class, (String)"ReactorLaserFocus");
        GameRegistry.registerTileEntity(TileEntityReactorNeutronCapture.class, (String)"ReactorNeutronCapture");
        GameRegistry.registerTileEntity(TileEntityReactorPort.class, (String)"ReactorPort");
        GameRegistry.registerTileEntity(TileEntityReactorLogicAdapter.class, (String)"ReactorLogicAdapter");
        GameRegistry.registerTileEntity(TileEntityRotationalComplex.class, (String)"RotationalComplex");
        GameRegistry.registerTileEntity(TileEntityElectromagneticCoil.class, (String)"ElectromagneticCoil");
        GameRegistry.registerTileEntity(TileEntitySaturatingCondenser.class, (String)"SaturatingCondenser");
    }

    public void registerSpecialTileEntities() {
        GameRegistry.registerTileEntity(TileEntityAdvancedSolarGenerator.class, (String)"AdvancedSolarGenerator");
        GameRegistry.registerTileEntity(TileEntitySolarGenerator.class, (String)"SolarGenerator");
        GameRegistry.registerTileEntity(TileEntityBioGenerator.class, (String)"BioGenerator");
        GameRegistry.registerTileEntity(TileEntityHeatGenerator.class, (String)"HeatGenerator");
        GameRegistry.registerTileEntity(TileEntityGasGenerator.class, (String)"GasGenerator");
        GameRegistry.registerTileEntity(TileEntityWindGenerator.class, (String)"WindTurbine");
        GameRegistry.registerTileEntity(TileEntityReactorController.class, (String)"ReactorController");
        GameRegistry.registerTileEntity(TileEntityTurbineRotor.class, (String)"TurbineRod");
        GameRegistry.registerTileEntity(TileEntityTurbineCasing.class, (String)"TurbineCasing");
        GameRegistry.registerTileEntity(TileEntityTurbineValve.class, (String)"TurbineValve");
        GameRegistry.registerTileEntity(TileEntityTurbineVent.class, (String)"TurbineVent");
    }

    public void registerItemRenders() {
    }

    public void registerBlockRenders() {
    }

    public void preInit() {
    }

    public void loadConfiguration() {
        MekanismConfig.generators.advancedSolarGeneration = Mekanism.configuration.get("generation", "AdvancedSolarGeneration", 300.0).getDouble();
        MekanismConfig.generators.bioGeneration = Mekanism.configuration.get("generation", "BioGeneration", 350.0).getDouble();
        MekanismConfig.generators.heatGeneration = Mekanism.configuration.get("generation", "HeatGeneration", 150.0).getDouble();
        MekanismConfig.generators.heatGenerationLava = Mekanism.configuration.get("generation", "HeatGenerationLava", 5.0).getDouble();
        MekanismConfig.generators.heatGenerationNether = Mekanism.configuration.get("generation", "HeatGenerationNether", 100.0).getDouble();
        MekanismConfig.generators.solarGeneration = Mekanism.configuration.get("generation", "SolarGeneration", 50.0).getDouble();
        this.loadWindConfiguration();
        MekanismConfig.generators.turbineBladesPerCoil = Mekanism.configuration.get("generation", "TurbineBladesPerCoil", 4).getInt();
        MekanismConfig.generators.turbineVentGasFlow = Mekanism.configuration.get("generation", "TurbineVentGasFlow", 16000.0).getDouble();
        MekanismConfig.generators.turbineDisperserGasFlow = Mekanism.configuration.get("generation", "TurbineDisperserGasFlow", 640.0).getDouble();
        MekanismConfig.generators.condenserRate = Mekanism.configuration.get("generation", "TurbineCondenserFlowRate", 32000).getInt();
        if (Mekanism.configuration.hasChanged()) {
            Mekanism.configuration.save();
        }
    }

    private void loadWindConfiguration() {
        MekanismConfig.generators.windGenerationMin = Mekanism.configuration.get("generation", "WindGenerationMin", 60.0).getDouble();
        MekanismConfig.generators.windGenerationMax = Mekanism.configuration.get("generation", "WindGenerationMax", 480.0).getDouble();
        int minY = Mekanism.configuration.get("generation", "WindGenerationMinY", 24).getInt();
        int maxY = Mekanism.configuration.get("generation", "WindGenerationMaxY", 255).getInt();
        MekanismConfig.generators.windGenerationMinY = minY;
        MekanismConfig.generators.windGenerationMaxY = Math.max(minY + 1, maxY);
    }

    public Object getClientGui(int ID, EntityPlayer player, World world, BlockPos pos) {
        return null;
    }

    public Container getServerGui(int ID, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        switch (ID) {
            case 0: {
                return new ContainerHeatGenerator(player.field_71071_by, (TileEntityHeatGenerator)tileEntity);
            }
            case 1: {
                return new ContainerSolarGenerator(player.field_71071_by, (TileEntitySolarGenerator)tileEntity);
            }
            case 3: {
                return new ContainerGasGenerator(player.field_71071_by, (TileEntityGasGenerator)tileEntity);
            }
            case 4: {
                return new ContainerBioGenerator(player.field_71071_by, (TileEntityBioGenerator)tileEntity);
            }
            case 5: {
                return new ContainerWindGenerator(player.field_71071_by, (TileEntityWindGenerator)tileEntity);
            }
            case 6: {
                return new ContainerFilter(player.field_71071_by, (TileEntityContainerBlock)((TileEntityTurbineCasing)tileEntity));
            }
            case 7: {
                return new ContainerNull(player, (TileEntityContainerBlock)((TileEntityTurbineCasing)tileEntity));
            }
            case 10: {
                return new ContainerReactorController(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 11: 
            case 12: 
            case 13: {
                return new ContainerNull(player, (TileEntityContainerBlock)tileEntity);
            }
            case 14: {
                return new ContainerNeutronCapture(player.field_71071_by, (TileEntityReactorNeutronCapture)tileEntity);
            }
            case 15: {
                return new ContainerNull(player, (TileEntityContainerBlock)tileEntity);
            }
        }
        return null;
    }
}

