/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mixin.transformer.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CtClass;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.InnerClassesAttribute;
import javassist.bytecode.LocalVariableTypeAttribute;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import reborncore.mixin.transformer.util.ClassEntry;
import reborncore.mixin.transformer.util.ClassNameReplacer;

public class ClassRenamer {
    public static void moveAllClassesOutOfDefaultPackage(CtClass c, String newPackageName) {
        ClassRenamer.renameClasses(c, className -> {
            ClassEntry entry = new ClassEntry(className);
            if (entry.isInDefaultPackage()) {
                return newPackageName + "/" + entry.getName();
            }
            return null;
        });
    }

    public static void moveAllClassesIntoDefaultPackage(CtClass c, String oldPackageName) {
        ClassRenamer.renameClasses(c, className -> {
            ClassEntry entry = new ClassEntry(className);
            if (entry.getPackageName().equals(oldPackageName)) {
                return entry.getSimpleName();
            }
            return null;
        });
    }

    public static void renameClasses(CtClass c, ClassNameReplacer replacer) {
        InnerClassesAttribute attr;
        ReplacerClassMap map = new ReplacerClassMap(replacer);
        ClassFile classFile = c.getClassFile();
        ConstPool constPool = c.getClassFile().getConstPool();
        constPool.renameClass(map);
        ClassRenamer.renameAttributes(classFile.getAttributes(), map, SignatureType.Class);
        for (MethodInfo methodInfo : classFile.getMethods()) {
            methodInfo.setDescriptor(Descriptor.rename(methodInfo.getDescriptor(), map));
            ClassRenamer.renameAttributes(methodInfo.getAttributes(), map, SignatureType.Method);
        }
        for (FieldInfo fieldInfo : classFile.getFields()) {
            fieldInfo.setDescriptor(Descriptor.rename(fieldInfo.getDescriptor(), map));
            ClassRenamer.renameAttributes(fieldInfo.getAttributes(), map, SignatureType.Field);
        }
        String newName = ClassRenamer.renameClassName(c.getName(), map);
        if (newName != null) {
            c.setName(newName);
        }
        if ((attr = (InnerClassesAttribute)c.getClassFile().getAttribute("InnerClasses")) != null) {
            for (int i = 0; i < attr.tableLength(); ++i) {
                ClassEntry classEntry = new ClassEntry(Descriptor.toJvmName(attr.innerClass(i)));
                if (attr.innerNameIndex(i) == 0) continue;
                attr.setInnerNameIndex(i, constPool.addUtf8Info(classEntry.getInnermostClassName()));
            }
        }
    }

    private static void renameAttributes(List<AttributeInfo> attributes, ReplacerClassMap map, SignatureType type) {
        try {
            Method renameClassMethod = AttributeInfo.class.getDeclaredMethod("renameClass", Map.class);
            renameClassMethod.setAccessible(true);
            for (AttributeInfo attribute : attributes) {
                if (attribute instanceof SignatureAttribute) {
                    SignatureAttribute signatureAttribute = (SignatureAttribute)attribute;
                    String newSignature = type.rename(signatureAttribute.getSignature(), map);
                    if (newSignature == null) continue;
                    signatureAttribute.setSignature(newSignature);
                    continue;
                }
                if (attribute instanceof CodeAttribute) {
                    CodeAttribute codeAttribute = (CodeAttribute)attribute;
                    ClassRenamer.renameAttributes(codeAttribute.getAttributes(), map, type);
                    continue;
                }
                if (attribute instanceof LocalVariableTypeAttribute) {
                    LocalVariableTypeAttribute localVariableAttribute = (LocalVariableTypeAttribute)attribute;
                    ClassRenamer.renameLocalVariableTypeAttribute(localVariableAttribute, map);
                    continue;
                }
                renameClassMethod.invoke((Object)attribute, map);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new Error("Unable to call javassist methods by reflection!", ex);
        }
    }

    private static void renameLocalVariableTypeAttribute(LocalVariableTypeAttribute attribute, ReplacerClassMap map) {
        ConstPool cp = attribute.getConstPool();
        int n = attribute.tableLength();
        byte[] info = attribute.get();
        for (int i = 0; i < n; ++i) {
            String signature;
            String newSignature;
            int pos = i * 10 + 2;
            int index = ByteArray.readU16bit(info, pos + 6);
            if (index == 0 || (newSignature = ClassRenamer.renameLocalVariableSignature(signature = cp.getUtf8Info(index), map)) == null) continue;
            ByteArray.write16bit(cp.addUtf8Info(newSignature), info, pos + 6);
        }
    }

    private static String renameLocalVariableSignature(String signature, ReplacerClassMap map) {
        int start = signature.lastIndexOf(36) + 1;
        int numConverted = 0;
        StringBuilder buf = new StringBuilder(signature);
        for (int i = buf.length() - 1; i >= start; --i) {
            char c = buf.charAt(i);
            if (c != '.') continue;
            buf.setCharAt(i, '$');
            ++numConverted;
        }
        signature = buf.toString();
        String newSignature = ClassRenamer.renameFieldSignature(signature, map);
        if (newSignature != null) {
            buf = new StringBuilder(newSignature);
            for (int i = buf.length() - 1; i >= 0 && numConverted > 0; --i) {
                char c = buf.charAt(i);
                if (c != '$') continue;
                buf.setCharAt(i, '.');
                --numConverted;
            }
            assert (numConverted == 0);
            newSignature = buf.toString();
            return newSignature;
        }
        return null;
    }

    private static String renameClassSignature(String signature, ReplacerClassMap map) {
        try {
            SignatureAttribute.ClassSignature type = ClassRenamer.renameType(SignatureAttribute.toClassSignature(signature), map);
            return type.encode();
        }
        catch (BadBytecode ex) {
            throw new Error("Can't parse field signature: " + signature);
        }
    }

    private static String renameFieldSignature(String signature, ReplacerClassMap map) {
        try {
            SignatureAttribute.ObjectType type = ClassRenamer.renameType(SignatureAttribute.toFieldSignature(signature), map);
            if (type != null) {
                return type.encode();
            }
            return null;
        }
        catch (BadBytecode ex) {
            throw new Error("Can't parse class signature: " + signature);
        }
    }

    private static String renameMethodSignature(String signature, ReplacerClassMap map) {
        try {
            SignatureAttribute.MethodSignature type = ClassRenamer.renameType(SignatureAttribute.toMethodSignature(signature), map);
            return type.encode();
        }
        catch (BadBytecode ex) {
            throw new Error("Can't parse method signature: " + signature);
        }
    }

    private static SignatureAttribute.ClassSignature renameType(SignatureAttribute.ClassSignature type, ReplacerClassMap map) {
        SignatureAttribute.ClassType[] interfaceTypes;
        SignatureAttribute.ClassType newSuperclassType;
        SignatureAttribute.ClassType superclassType;
        SignatureAttribute.TypeParameter[] typeParamTypes = type.getParameters();
        if (typeParamTypes != null) {
            typeParamTypes = Arrays.copyOf(typeParamTypes, typeParamTypes.length);
            for (int i = 0; i < typeParamTypes.length; ++i) {
                SignatureAttribute.TypeParameter newParamType = ClassRenamer.renameType(typeParamTypes[i], map);
                if (newParamType == null) continue;
                typeParamTypes[i] = newParamType;
            }
        }
        if ((superclassType = type.getSuperClass()) != SignatureAttribute.ClassType.OBJECT && (newSuperclassType = ClassRenamer.renameType(superclassType, map)) != null) {
            superclassType = newSuperclassType;
        }
        if ((interfaceTypes = type.getInterfaces()) != null) {
            interfaceTypes = Arrays.copyOf(interfaceTypes, interfaceTypes.length);
            for (int i = 0; i < interfaceTypes.length; ++i) {
                SignatureAttribute.ClassType newInterfaceType = ClassRenamer.renameType(interfaceTypes[i], map);
                if (newInterfaceType == null) continue;
                interfaceTypes[i] = newInterfaceType;
            }
        }
        return new SignatureAttribute.ClassSignature(typeParamTypes, superclassType, interfaceTypes);
    }

    private static SignatureAttribute.MethodSignature renameType(SignatureAttribute.MethodSignature type, ReplacerClassMap map) {
        SignatureAttribute.ObjectType[] exceptionTypes;
        SignatureAttribute.Type newReturnType;
        SignatureAttribute.Type returnType;
        SignatureAttribute.Type[] paramTypes;
        SignatureAttribute.TypeParameter[] typeParamTypes = type.getTypeParameters();
        if (typeParamTypes != null) {
            typeParamTypes = Arrays.copyOf(typeParamTypes, typeParamTypes.length);
            for (int i = 0; i < typeParamTypes.length; ++i) {
                SignatureAttribute.TypeParameter newParamType = ClassRenamer.renameType(typeParamTypes[i], map);
                if (newParamType == null) continue;
                typeParamTypes[i] = newParamType;
            }
        }
        if ((paramTypes = type.getParameterTypes()) != null) {
            paramTypes = Arrays.copyOf(paramTypes, paramTypes.length);
            for (int i = 0; i < paramTypes.length; ++i) {
                SignatureAttribute.Type newParamType = ClassRenamer.renameType(paramTypes[i], map);
                if (newParamType == null) continue;
                paramTypes[i] = newParamType;
            }
        }
        if ((returnType = type.getReturnType()) != null && (newReturnType = ClassRenamer.renameType(returnType, map)) != null) {
            returnType = newReturnType;
        }
        if ((exceptionTypes = type.getExceptionTypes()) != null) {
            exceptionTypes = Arrays.copyOf(exceptionTypes, exceptionTypes.length);
            for (int i = 0; i < exceptionTypes.length; ++i) {
                SignatureAttribute.ObjectType newExceptionType = ClassRenamer.renameType(exceptionTypes[i], map);
                if (newExceptionType == null) continue;
                exceptionTypes[i] = newExceptionType;
            }
        }
        return new SignatureAttribute.MethodSignature(typeParamTypes, paramTypes, returnType, exceptionTypes);
    }

    private static SignatureAttribute.Type renameType(SignatureAttribute.Type type, ReplacerClassMap map) {
        if (type instanceof SignatureAttribute.ObjectType) {
            return ClassRenamer.renameType((SignatureAttribute.ObjectType)type, map);
        }
        if (type instanceof SignatureAttribute.BaseType) {
            return ClassRenamer.renameType((SignatureAttribute.BaseType)type, map);
        }
        throw new Error("Don't know how to rename type " + type.getClass());
    }

    private static SignatureAttribute.ObjectType renameType(SignatureAttribute.ObjectType type, ReplacerClassMap map) {
        if (type instanceof SignatureAttribute.ArrayType) {
            return ClassRenamer.renameType((SignatureAttribute.ArrayType)type, map);
        }
        if (type instanceof SignatureAttribute.ClassType) {
            return ClassRenamer.renameType((SignatureAttribute.ClassType)type, map);
        }
        if (type instanceof SignatureAttribute.TypeVariable) {
            return ClassRenamer.renameType((SignatureAttribute.TypeVariable)type, map);
        }
        throw new Error("Don't know how to rename type " + type.getClass());
    }

    private static SignatureAttribute.BaseType renameType(SignatureAttribute.BaseType type, ReplacerClassMap map) {
        return null;
    }

    private static SignatureAttribute.TypeVariable renameType(SignatureAttribute.TypeVariable type, ReplacerClassMap map) {
        return null;
    }

    private static SignatureAttribute.ClassType renameType(SignatureAttribute.ClassType type, ReplacerClassMap map) {
        SignatureAttribute.TypeArgument[] args = type.getTypeArguments();
        if (args != null) {
            args = Arrays.copyOf(args, args.length);
            for (int i = 0; i < args.length; ++i) {
                SignatureAttribute.TypeArgument newType = ClassRenamer.renameType(args[i], map);
                if (newType == null) continue;
                args[i] = newType;
            }
        }
        if (type instanceof SignatureAttribute.NestedClassType) {
            SignatureAttribute.ClassType parent;
            SignatureAttribute.NestedClassType nestedType = (SignatureAttribute.NestedClassType)type;
            String name = ClassRenamer.getClassName(type);
            String newName = map.get(name);
            if (newName != null) {
                name = new ClassEntry(newName).getInnermostClassName();
            }
            if ((parent = ClassRenamer.renameType(nestedType.getDeclaringClass(), map)) == null) {
                parent = nestedType.getDeclaringClass();
            }
            return new SignatureAttribute.NestedClassType(parent, name, args);
        }
        String name = type.getName();
        String newName = ClassRenamer.renameClassName(name, map);
        if (newName != null) {
            name = newName;
        }
        return new SignatureAttribute.ClassType(name, args);
    }

    private static String getClassName(SignatureAttribute.ClassType type) {
        if (type instanceof SignatureAttribute.NestedClassType) {
            SignatureAttribute.NestedClassType nestedType = (SignatureAttribute.NestedClassType)type;
            return ClassRenamer.getClassName(nestedType.getDeclaringClass()) + "$" + Descriptor.toJvmName(type.getName().replace('.', '$'));
        }
        return Descriptor.toJvmName(type.getName());
    }

    private static String renameClassName(String name, ReplacerClassMap map) {
        String newName = map.get(Descriptor.toJvmName(name));
        if (newName != null) {
            return Descriptor.toJavaName(newName);
        }
        return null;
    }

    private static SignatureAttribute.TypeArgument renameType(SignatureAttribute.TypeArgument type, ReplacerClassMap map) {
        SignatureAttribute.ObjectType newSubType;
        SignatureAttribute.ObjectType subType = type.getType();
        if (subType != null && (newSubType = ClassRenamer.renameType(subType, map)) != null) {
            switch (type.getKind()) {
                case ' ': {
                    return new SignatureAttribute.TypeArgument(newSubType);
                }
                case '+': {
                    return SignatureAttribute.TypeArgument.subclassOf(newSubType);
                }
                case '-': {
                    return SignatureAttribute.TypeArgument.superOf(newSubType);
                }
            }
            throw new Error("Unknown type kind: " + type.getKind());
        }
        return null;
    }

    private static SignatureAttribute.ArrayType renameType(SignatureAttribute.ArrayType type, ReplacerClassMap map) {
        SignatureAttribute.Type newSubType = ClassRenamer.renameType(type.getComponentType(), map);
        if (newSubType != null) {
            return new SignatureAttribute.ArrayType(type.getDimension(), newSubType);
        }
        return null;
    }

    private static SignatureAttribute.TypeParameter renameType(SignatureAttribute.TypeParameter type, ReplacerClassMap map) {
        SignatureAttribute.ObjectType[] interfaceTypes;
        SignatureAttribute.ObjectType newSuperclassType;
        SignatureAttribute.ObjectType superclassType = type.getClassBound();
        if (superclassType != null && (newSuperclassType = ClassRenamer.renameType(superclassType, map)) != null) {
            superclassType = newSuperclassType;
        }
        if ((interfaceTypes = type.getInterfaceBound()) != null) {
            interfaceTypes = Arrays.copyOf(interfaceTypes, interfaceTypes.length);
            for (int i = 0; i < interfaceTypes.length; ++i) {
                SignatureAttribute.ObjectType newInterfaceType = ClassRenamer.renameType(interfaceTypes[i], map);
                if (newInterfaceType == null) continue;
                interfaceTypes[i] = newInterfaceType;
            }
        }
        return new SignatureAttribute.TypeParameter(type.getName(), superclassType, interfaceTypes);
    }

    private static class ReplacerClassMap
    extends HashMap<String, String> {
        private ClassNameReplacer m_replacer;

        public ReplacerClassMap(ClassNameReplacer replacer) {
            this.m_replacer = replacer;
        }

        @Override
        public String get(Object obj) {
            if (obj instanceof String) {
                return this.get((String)obj);
            }
            return null;
        }

        public String get(String className) {
            return this.m_replacer.replace(className);
        }
    }

    private static enum SignatureType {
        Class{

            @Override
            public String rename(String signature, ReplacerClassMap map) {
                return ClassRenamer.renameClassSignature(signature, map);
            }
        }
        ,
        Field{

            @Override
            public String rename(String signature, ReplacerClassMap map) {
                return ClassRenamer.renameFieldSignature(signature, map);
            }
        }
        ,
        Method{

            @Override
            public String rename(String signature, ReplacerClassMap map) {
                return ClassRenamer.renameMethodSignature(signature, map);
            }
        };


        public abstract String rename(String var1, ReplacerClassMap var2);
    }
}

