/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.Validate;
import reborncore.RebornCore;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;

public class PacketWrapper
implements IMessage {
    INetworkPacket packet;

    public PacketWrapper(INetworkPacket packet) {
        this.packet = packet;
    }

    public PacketWrapper() {
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.packet = NetworkManager.packetHashMap.get(buf.readInt()).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        try {
            this.packet.readData(new ExtendedPacketBuffer(buf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        Validate.notNull((Object)this.packet);
        buf.writeInt(NetworkManager.packetHashMapReverse.get(this.packet.getClass()).intValue());
        try {
            this.packet.writeData(new ExtendedPacketBuffer(buf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class PacketWrapperHandler
    implements IMessageHandler<PacketWrapper, IMessage> {
        public IMessage onMessage(PacketWrapper message, MessageContext ctx) {
            if (message == null || message.packet == null) {
                return null;
            }
            try {
                message.packet.processData(message.packet, ctx);
            }
            catch (Exception e) {
                RebornCore.logHelper.error("Packet " + message.packet.getClass() + " could not be handled, it will be ignored, please report to the mod dev.");
                e.printStackTrace();
            }
            return null;
        }
    }
}

