/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.style.stylesheet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.shadowfacts.shadowmc.ui.UIElement;
import net.shadowfacts.shadowmc.ui.element.view.UIView;
import net.shadowfacts.shadowmc.ui.style.stylesheet.Rule;

public class Stylesheet {
    private Multimap<String, Rule<?>> typeRules = HashMultimap.create();
    private Multimap<String, Rule<?>> idRules = HashMultimap.create();
    private Multimap<String, Rule<?>> classRules = HashMultimap.create();

    public void addTypeRule(String type, Rule<?> rule) {
        this.typeRules.put((Object)type, rule);
    }

    public void addIDRule(String id, Rule<?> rule) {
        this.idRules.put((Object)id, rule);
    }

    public void addClassRule(String clazz, Rule<?> rule) {
        this.classRules.put((Object)clazz, rule);
    }

    public void style(UIElement e) {
        this.typeRules.get((Object)e.getType()).forEach(e::applyRule);
        this.idRules.get((Object)e.getID()).forEach(e::applyRule);
        e.getClasses().stream().map(arg_0 -> this.classRules.get(arg_0)).flatMap(Collection::stream).forEach(e::applyRule);
        if (e instanceof UIView) {
            ((UIView)e).getChildren().forEach(this::style);
        }
    }
}

