/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.gui.component.button;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.shadowfacts.shadowlib.util.EnumUtils;
import net.shadowfacts.shadowmc.gui.component.button.GUIButton;
import net.shadowfacts.shadowmc.util.MouseButton;
import net.shadowfacts.shadowmc.util.RedstoneMode;

public class GUIButtonRedstoneMode
extends GUIButton {
    protected RedstoneMode redstoneMode;
    protected Consumer<RedstoneMode> handler;

    public GUIButtonRedstoneMode(int x, int y, RedstoneMode redstoneMode, Consumer<RedstoneMode> handler) {
        super(x, y, 20, 20);
        this.redstoneMode = redstoneMode;
        this.handler = handler;
    }

    public GUIButtonRedstoneMode(int x, int y, Consumer<RedstoneMode> handler) {
        this(x, y, RedstoneMode.ALWAYS, handler);
    }

    @Override
    protected boolean handlePress(MouseButton button) {
        this.setRedstoneMode(EnumUtils.getNextValue(this.redstoneMode));
        this.handler.accept(this.redstoneMode);
        return true;
    }

    @Override
    protected void drawButton() {
        this.bindTexture(widgetTextures);
        switch (this.redstoneMode) {
            case ALWAYS: {
                this.drawTexturedRect(this.x, this.y, 80, 0, this.width, this.height);
                break;
            }
            case NEVER: {
                this.drawTexturedRect(this.x, this.y, 100, 0, this.width, this.height);
                break;
            }
            case HIGH: {
                this.drawTexturedRect(this.x, this.y, 60, 0, this.width, this.height);
                break;
            }
            case LOW: {
                this.drawTexturedRect(this.x, this.y, 40, 0, this.width, this.height);
                break;
            }
            case PULSE: {
                this.drawTexturedRect(this.x, this.y, 120, 0, this.width, this.height);
            }
        }
    }

    @Override
    public List<String> getTooltip() {
        return Collections.singletonList(this.redstoneMode.localize());
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
    }
}

